package cn.com.duiba.tuia.activity.center.api.dto.staticpage;

import java.io.Serializable;
import java.util.Date;

public class VerifyPageResultDto implements Serializable {

    private static final long serialVersionUID = -5093030621702930372L;

    /**
     * 审核id
     */
    private Long id;

    /**
     * 审核平台 1-爱奇艺
     */
    private Integer platformType;

    /**
     * 审核页面类型 1：活动，2：落地页
     */
    private Integer pageType;

    /**
     * 页面id
     */
    private Long pageId;

    /**
     * 页面url
     */
    private String tuiaUrl;

    /**
     * 平台审核后给出的url
     */
    private String thirdUrl;

    /**
     * 平台流水号
     * e.g. 爱奇艺审核ID(fileId)
     */
    private String thirdSerialNo;

    /**
     * 平台应用ID（该字段未持久化，仅在审核通过后返回，后面推动改造让使用方在Web层转换为VO）
     * e.g. 爱奇艺站点ID（仅在审核通过后返回的托管页面URL中解析）
     */
    private String thirdAppId;

    /**
     * 审核状态 （1：送审中，2-审核通过 3-审核拒绝）
     */
    private Integer lastStatus;

    /**
     * 最后一次送审时间
     */
    private Date lastSendGmt;

    /**
     * 最后审核回调时间
     */
    private Date lastCallbackGmt;

    /**
     * 审核拒绝原因
     */
    private String refuseReason;

    private String encryptValue;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPlatformType() {
        return platformType;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public void setLastStatus(Integer lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getTuiaUrl() {
        return tuiaUrl;
    }

    public void setTuiaUrl(String tuiaUrl) {
        this.tuiaUrl = tuiaUrl;
    }

    public String getThirdUrl() {
        return thirdUrl;
    }

    public void setThirdUrl(String thirdUrl) {
        this.thirdUrl = thirdUrl;
    }

    public String getThirdSerialNo() {
        return thirdSerialNo;
    }

    public void setThirdSerialNo(String thirdSerialNo) {
        this.thirdSerialNo = thirdSerialNo;
    }

    public String getThirdAppId() {
        return thirdAppId;
    }

    public void setThirdAppId(String thirdAppId) {
        this.thirdAppId = thirdAppId;
    }

    public Integer getLastStatus() {
        return lastStatus;
    }

    public Date getLastSendGmt() {
        return lastSendGmt;
    }

    public void setLastSendGmt(Date lastSendGmt) {
        this.lastSendGmt = lastSendGmt;
    }

    public Date getLastCallbackGmt() {
        return lastCallbackGmt;
    }

    public void setLastCallbackGmt(Date lastCallbackGmt) {
        this.lastCallbackGmt = lastCallbackGmt;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public String getEncryptValue() {
        return encryptValue;
    }

    public void setEncryptValue(String encryptValue) {
        this.encryptValue = encryptValue;
    }

    @Override
    public String toString() {
        return "VerifyPageResultDto{" +
                "id=" + id +
                ", platformType=" + platformType +
                ", pageType=" + pageType +
                ", pageId=" + pageId +
                ", tuiaUrl='" + tuiaUrl + '\'' +
                ", thirdUrl='" + thirdUrl + '\'' +
                ", thirdSerialNo='" + thirdSerialNo + '\'' +
                ", thirdAppId='" + thirdAppId + '\'' +
                ", lastStatus=" + lastStatus +
                ", lastSendGmt=" + lastSendGmt +
                ", lastCallbackGmt=" + lastCallbackGmt +
                ", refuseReason='" + refuseReason + '\'' +
                ", encryptValue='" + encryptValue + '\'' +
                '}';
    }
}
