package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.SkinIndustryTemplateDTO;
import cn.com.duiba.tuia.activity.center.api.dto.req.SkinIndustryTemplateQueryReq;

/**
 * @author Wangpf
 * @date 2024/2/26 16:00
 */
@AdvancedFeignClient
public interface RemoteSkinIndustryTemplateService {

    /**
     * 分页查询弹层皮肤
     *
     * @param req
     * @return PageDto
     */
    PageDto<SkinIndustryTemplateDTO> selectLayerSkinPage(SkinIndustryTemplateQueryReq req);

    /**
     * 查询弹层皮肤
     *
     * @param id
     * @return
     */
    SkinIndustryTemplateDTO selectLayerSkin(Long id);

    /**
     * 保存弹层皮肤
     *
     * @param dto dto
     * @return ids
     */
    Long saveLayerSkin(SkinIndustryTemplateDTO dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int deleteById(Long id);
    
}
