package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProgrammaticFissionActivityDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProgrammaticFissionActivityQueryDto;

import java.util.List;

/**
 * ClassName: RemoteActivityService <br/>
 * Function: 活动服务和活动奖项，皮肤相关服务. <br/>
 * date: 2017年1月12日 下午9:15:42 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteProgrammaticFissionActivityService {
    Long addActivity(ProgrammaticFissionActivityDto dto);

    PageDto<ProgrammaticFissionActivityDto> page(ProgrammaticFissionActivityQueryDto dto);

    List<ProgrammaticFissionActivityDto> list(ProgrammaticFissionActivityQueryDto dto);

    ProgrammaticFissionActivityDto getByActivityId(Long activityId);

    ProgrammaticFissionActivityDto getById(Long id);

    Boolean update(ProgrammaticFissionActivityDto dto);

    Long batchInsert(List<ProgrammaticFissionActivityDto> list);

    List<ProgrammaticFissionActivityDto> listByIds(List<Long> ids);

    List<ProgrammaticFissionActivityDto> listAll(ProgrammaticFissionActivityDto dto);

    List<ProgrammaticFissionActivityDto> listIncludedInstance(ProgrammaticFissionActivityDto dto);

    Boolean hardDelete(Long programmaticActivityId);

    Boolean softDelete(Long programmaticActivityId);

    Boolean batchUpdateStatus(List<Long> idList, Integer status);
}
