package cn.com.duiba.tuia.activity.center.api.req.adx;

import cn.com.duiba.tuia.activity.center.api.annotation.AdxBidFullLink;
import lombok.Data;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx曝光成功记录信息
 *
 * @author hillchen
 * @create 2019/2/27 00:48
 */
@Data
public class AdxSuccBidInfo implements Serializable {

    private static final long serialVersionUID = 6996300130162900166L;

    /**
     * adx全链路请求标示
     */
    private String adxRid;

    /**
     * 媒体请求id
     */
    private String requestId;

    /**
     * adx平台广告位id
     */
    private String tagId;
    /**
     * 广告位索引
     */
    private String tagIndex;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * 创意id
     */
    private Long ideaId;


    /**
     * 对应tuia的广告位id
     */
    private Long slotId;

    /**
     * 对应tuia的应用id
     */
    private Long addId;

    /**
     * 标准出价:分/1000次
     */
    private Long bidPrice;

    /**
     * 标准扣费:分/1000次
     */
    private Long feePrice;

    /**
     * 创意投放方式：0:依次投放,1:按比例投放
     */
    private Integer putType;

    /**
     * 出价类型0:人工出价,1:算法出价
     */
    private Integer priceType;

    /**
     * 计费方式：0:cpc，1:cpm（现有的adx都是cpm计费方式）
     */
    private Integer billType;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;

    /**
     * 记录状态：0:竞价返回，1:竞价成功，2:创意曝光，3:创意点击
     */
    private Integer recodeStatus;

    /** adxPriceLevel */
    private Integer adxPriceLevel;

    /** isCompareGroup */
    private String isCompareGroup;

    /** 策略类型 */
    private String strategy;

    /** 试探level */
    private String level;

    /** 拓展字段（map转string存入，防止反序列化时出现异常） */
    private String extMap;

    /** 策略类型 每个数字代表一个算法模型 示例 1 */
    private String algType;

    /**
     * 经纬度
     */
    private Double longitude;

    /**
     * 经纬度
     */
    private Double latitude;

    /**
     * 经纬度hash
     */
    private String geohash;

    /** 推广组ID */
    private String groupId;

    /** 1:预发券 2:非预发券 **/
    private Integer preLaunch;

    /** 0-免费 1-付费 **/
    private Integer appPaid;

    /** 0.测试组 1.对照组 **/
    private Integer isTestGroup;

    /**
     * ctr预估区间
     */
    @AdxBidFullLink
    private Integer preInterval;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    @AdxBidFullLink
    private Integer filterIndex;

    /**
     * pmp类型 0-RTB 1-PD 2-PDB
     */
    @AdxBidFullLink
    private Integer pmpType;

    /**
     * 推啊排期单ID
     */
    @AdxBidFullLink
    private Long tuiaDealId;

    /**
     * 点击价值分层
     */
    @AdxBidFullLink
    private Integer clickValueLevel;

    /**
     * 点击价值纠偏因子
     */
    @AdxBidFullLink
    private Double clickValueRectifyFactor;

    /**
     * 预估点击价值(TFModel)
     */
    @AdxBidFullLink
    private Double preClickValue;

    /**
     * 统计点击价值
     */
    @AdxBidFullLink
    private Double statClickValue;

    /**
     * 百度联盟appId标识符
     */
    @AdxBidFullLink
    private String baiduAppId;

    /**
     * pc端用户id(目前给百度联盟用的)
     */
    @AdxBidFullLink
    private String thirdUserId;

    /**
     * 广告计划Id
     */
    @AdxBidFullLink
    private Long advertId;

    /**
     * 定向配置包 Id
     */
    @AdxBidFullLink
    private Long orientationId;

    /**
     * 素材 Id
     */
    @AdxBidFullLink
    private Long materialId;

    /* 算法出价模式 */
    @AdxBidFullLink
    private Integer algoBidMode;

    /* 算法过滤原因 */
    @AdxBidFullLink
    private Integer filterType;

    /* 每PV发券预估值 */
    @AdxBidFullLink
    private Double preLaunchPv;

    /**
     * 频次等级：1.强 2.中 3.弱
     */
    @AdxBidFullLink
    private Integer frequencyLevel;

    /** 流量abtest组别  1=adx非测试流量，2=无，3=每pv发券，4=每pv点券 **/
    @AdxBidFullLink
    private Integer flowGroup;

    /**
     * 创意预估流量质量策略
     * 0=无，1=每pv发券，2=每pv点券
     */
    @AdxBidFullLink
    private Integer baseFilterFlag;

    /** 每PV点券预估值 **/
    @AdxBidFullLink
    private Double preChargePv;

    /** 互动创意类型 （0-普通-静态，1-动态-dpa） **/
    @AdxBidFullLink
    private Integer idea_type;

    /** adx入口素材id **/
    @AdxBidFullLink
    private Long sckId;

    /** 流量测试组 示例："flow_filter_test":"[{"flow_exp_id":"2" ,"group_tag":0}]" **/
    @AdxBidFullLink
    private String flow_filter_test;

    /** adx入口素材url **/
    private String sck_url;

    /**
     * adx直投订单id
     */
    @AdxBidFullLink
    private String orderId;

    private String deepLinkUrl;

    /**
     * 外部流量包ID
     */
    @AdxBidFullLink
    private String externalDataPackageId;

    /**
     * 外部广告位ID
     */
    @AdxBidFullLink
    private String externalAdBlockId;

    /**
     * 创意素材投放类型
     * @see cn.com.duiba.tuia.activity.center.api.constant.adx.UnitPutTypeEnum
     */
    @AdxBidFullLink
    private Integer unit_put_type;

    /**
     * 创意素材ID
     */
    @AdxBidFullLink
    private Long unit_id;

    /**
     * 创意素材尺寸
     */
    @AdxBidFullLink
    private String unit_size;

    /**
     * 创意素材标签ID list
     */
    @AdxBidFullLink
    private String unit_tag_List;

    /**
     * adx用户标签
     */
    @AdxBidFullLink
    private String adx_user_tag;

    /**
     * adx类型
     */
    @AdxBidFullLink
    private Integer adxType;

    /**
     * 外部广告位类型ID
     */
    @AdxBidFullLink
    private String externalAdBlockTypeId;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    @AdxBidFullLink
    private Integer exploreType;

    /**
     * 联盟行业id
     */
    @AdxBidFullLink
    private String extAppTrade;

    /**
     * 预估ctr
     */
    @AdxBidFullLink
    private Double preCtr;

    /**
     * 统计ctr
     */
    @AdxBidFullLink
    private Double statCtr;

    /**
     * 融合ctr
     */
    @AdxBidFullLink
    private Double ctr;

    /**
     * 统计pv
     */
    @AdxBidFullLink
    private Double statLaunchPv;

    /**
     * 融合pv
     */
    @AdxBidFullLink
    private Double launchPv;

    /**
     * 预估arpu
     */
    @AdxBidFullLink
    private Double preArpu;

    /**
     * 统计arpu
     */
    @AdxBidFullLink
    private Double arpu;

    /**
     * 融合arpu
     */
    @AdxBidFullLink
    private Double mixArpu;

    /**
     * 预估clickPv
     */
    @AdxBidFullLink
    private Double preClickPv;

    /**
     * 统计clickPv
     */
    @AdxBidFullLink
    private Double statClickPv;

    /**
     * 融合clickPv
     */
    @AdxBidFullLink
    private Double mergeClickPv;

    /**
     * 预估adCpc
     */
    @AdxBidFullLink
    private Double preAdCpc;

    /**
     * 统计adCpc
     */
    @AdxBidFullLink
    private Double statAdCpc;

    /**
     * 融合adCpc
     */
    @AdxBidFullLink
    private Double mergeAdCpc;

    /**
     * 竞价胜出:分
     */
    private String winPrice;

    /**
     * 是否开启计划冷启动探价：关闭=0，开启=1
     */
    @AdxBidFullLink
    private Integer coldStartExploreStatus;

    /**
     * 计划冷启动探价预算/分
     */
    private Long coldStartExploreFee;

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 流量聚合id
     */
    @AdxBidFullLink
    private String flowPolyId;

    /**
     * oneId 请求dmp生成
     */
    private String oneId;

    /**
     * 1：有设备号的oneId生成，2：没有设备号的oneId生成
     */
    private Integer oneIdType;

    /**
     * 发券方式
     */
    @AdxBidFullLink
    private Integer adxLaunchType;

    /**
     * 融合cvr
     */
    @AdxBidFullLink
    private Double mergeCvr;

    /**
     * 预估cvr
     */
    @AdxBidFullLink
    private Double preCvr;

    /**
     * 统计cvr
     */
    @AdxBidFullLink
    private Double statCvr;

    /**
     * 首发券广告id
     */
    @AdxBidFullLink
    private Long flcAdvertId;

    /**
     * 设备品牌名称
     */
    @AdxBidFullLink
    private String deviceBrand;

    /**
     * 机型
     */
    @AdxBidFullLink
    private String model;

    /**
     * ip
     */
    @AdxBidFullLink
    private String ip;

    /**
     * 人群打分系数
     */
    private Double userScore;

    /**
     * 人群打分系数V2
     */
    private Double userScoreV2;
    /**
     * 出价
     */
    private Long adxAlgoPrice;
    /**
     * 预估曝光价值
     */
    private Double preEcpm;
    /**
     * 预估点击价值
     */
    private Double preEcpc;
    /**
     * 目标roi
     */
    private Double minRoi;
    /**
     * 目标cpc
     */
    private Double targetCpc;

    private String deviceId;

    /**
     * 1-真实；2-虚拟
     */
    private Integer deviceIdType = 1;

    /**
     * 媒体支持的计费类型（暂时只有百度联盟）
     * 0：cpm
     * 1：cpc
     * 2：ocpm
     */
    @AdxBidFullLink
    private Integer mediaChargeType;


    /**
     * 广告位底价(单位:分)
     */
    private Double floorPrice;

    /**
     * 包名(平台定义的应用唯一标示)
     */
    @AdxBidFullLink
    private String packageName;

    /**
     * dsp返回出价
     */
    private Double dspBidPrice;


    /**
     * 扩展map的key
     */
    public static class ExtMapKey {

        /** 预发券入参的key */
        public static String PRE_LOAD_ADVERT_PARAMS = "preLoadAdvertParams";
    }
}
