package cn.com.duiba.tuia.activity.center.api.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * 正则表达式工具类
 *
 * @author zhangbaiqiang
 * @date 2018/7/26
 */
public class RegexUtil {

    //移动端user-agent的正则表达式
    private static final String REGEX_MOBILE_USER_AGENT = "Mobile|Android|webOS|iPhone|iPad|iPod|BlackBerry|UCWEB";

    //局域网IP的正则表达式
    private static final String REGEX_LAN_IP = "(127[.]0[.]0[.]1)|" + "(localhost)|" +
            "(10[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})|" +
            "(172[.]((1[6-9])|(2\\d)|(3[01]))[.]\\d{1,3}[.]\\d{1,3})|" +
            "(192[.]168[.]\\d{1,3}[.]\\d{1,3})";


    /**
     * 判断user-agent是否是移动端
     *
     * @param userAgent 浏览器标识user-agent
     * @return true.移动端 false.PC端
     */
    public static boolean isMobileUA(String userAgent) {
        if (StringUtils.isBlank(userAgent)) {
            return false;
        }
        return Pattern.compile(REGEX_MOBILE_USER_AGENT, Pattern.CASE_INSENSITIVE).matcher(userAgent).find();
    }

    /**
     * 判断IP是否属于局域网
     *
     * @param ip ip地址
     * @return true.局域网 false.非局域网
     */
    public static boolean isLAN(String ip) {
        if (StringUtils.isBlank(ip)) {
            return false;
        }
        return Pattern.compile(REGEX_LAN_IP, Pattern.CASE_INSENSITIVE).matcher(ip).find();
    }
}
