package cn.com.duiba.tuia.activity.center.api.dto.story.tree;

import cn.com.duiba.tuia.activity.center.api.dto.commercial.common.MissionDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StoryUserSpikeInitInfoDto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * [商业化活动]种树主Dto
 *
 * @author zhangbaiqiang
 * @date 2019-05-31
 */
public class TreeDto implements Serializable {
    private static final long serialVersionUID = 6949375909074470054L;

    /**
     * 用户信息
     */
    private TreeUserDto user;

    /**
     * 签到信息
     */
    private TreeSignDto sign;

    /**
     * 奖励信息
     */
    private TreePrizeDto prize;

    /**
     * 任务
     */
    private List<MissionDto> mission;

    /**
     * 树
     */
    private TreeTreeDto tree;

    /**
     * 当前位置(果实)列表
     */
    private List<TreeLandDto> lands;

    /**
     * 降级前的位置(果实)列表
     */
    private List<TreeLandDto> beforeLands;

    /**
     * 道具
     */
    private Map<Integer, TreePropDto> props;

    /**
     * 秒杀信息
     */
    private StoryUserSpikeInitInfoDto spikeInfo;


    public StoryUserSpikeInitInfoDto getSpikeInfo() {
        return spikeInfo;
    }

    public void setSpikeInfo(StoryUserSpikeInitInfoDto spikeInfo) {
        this.spikeInfo = spikeInfo;
    }

    public TreeUserDto getUser() {
        return user;
    }

    public void setUser(TreeUserDto user) {
        this.user = user;
    }

    public List<MissionDto> getMission() {
        return mission;
    }

    public void setMission(List<MissionDto> mission) {
        this.mission = mission;
    }

    public TreeSignDto getSign() {
        return sign;
    }

    public void setSign(TreeSignDto sign) {
        this.sign = sign;
    }

    public TreePrizeDto getPrize() {
        return prize;
    }

    public void setPrize(TreePrizeDto prize) {
        this.prize = prize;
    }

    public TreeTreeDto getTree() {
        return tree;
    }

    public void setTree(TreeTreeDto tree) {
        this.tree = tree;
    }

    public List<TreeLandDto> getLands() {
        return lands;
    }

    public void setLands(List<TreeLandDto> lands) {
        this.lands = lands;
    }

    public List<TreeLandDto> getBeforeLands() {
        return beforeLands;
    }

    public void setBeforeLands(List<TreeLandDto> beforeLands) {
        this.beforeLands = beforeLands;
    }

    public Map<Integer, TreePropDto> getProps() {
        return props;
    }

    public void setProps(Map<Integer, TreePropDto> props) {
        this.props = props;
    }
}
