package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ShieldRuleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName: RemoteShieldRuleService <br/>
 * Function: 活动屏蔽规则相关服务. <br/>
 * date: 2017年1月12日 下午9:15:42 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteShieldRuleService {

    /**
     * 更新规则是否开启:(查询活动). <br/>
     *
     * @param id the id
     * @param isOpen  是否开启
     * @return the activity
     * @author cdm
     * @since JDK 1.7
     */
    DubboResult<Boolean> updateIsOpen(Long id,int isOpen);

    /**
     * getAllList:(查询所有的规则list). <br/>
     *
     * @return the ShieldRuleDto list
     * @author cdm
     * @since JDK 1.7
     */
    DubboResult<List<ShieldRuleDto>> getAllList();

    /**
     * 根据规则内容和规则type查询活动规则
     * @param ruleContent 规则内容
     * @param ruleType   规则类型
     * @return List<ShieldRuleDto>
     */
    DubboResult<PageDto<ShieldRuleDto>> selectByRulePage(Integer offset, Integer max, String ruleContent, Integer ruleType);

    /**
     * insertShieldRule:(插入规则). <br/>
     * 软删
     *
     * @param shieldRuleDto the shieldRuleDto
     * @return the dubbo result< Boolean>
     * @author cdm
     * @since JDK 1.7
     */
    DubboResult<Boolean> insertShieldRule(ShieldRuleDto shieldRuleDto);

    /**
     * selectById:(根据id查询规则). <br/>
     *
     * @param id is id
     * @return ShieldRuleDto
     * @author cdm
     * @since JDK 1.7
     */
    DubboResult<ShieldRuleDto> selectById(Long  id);


    /**
     * updateShieldRuleById:(更新屏蔽规则). <br/>
     *
     * @param shieldRuleDto
     * @return Boolean
     * @author cdm
     * @since JDK 1.7
     */
    DubboResult<Boolean> updateShieldRuleById(ShieldRuleDto shieldRuleDto);



}
