package cn.com.duiba.tuia.activity.center.api.dto.reward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 激励互动奖励DTO
 *
 * @author zhangbaiqiang
 * @date 2019-07-12
 */
@ApiModel
public class RewardedActivityPrizeDto implements Serializable {
    private static final long serialVersionUID = -1333184941576009253L;

    @ApiModelProperty(value = "奖品id")
    private Long prizeId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品标识")
    private String prizeFlag;

    @ApiModelProperty(value = "本次奖励系数(实际系数*100)")
    private Integer currentRatio;

    @ApiModelProperty(value = "累加奖励系数(实际系数*100)")
    private Integer totalRatio;

    @ApiModelProperty(value = "分值(实际分值*100)")
    private Integer score;

    @ApiModelProperty(value = "是否开启激励视频")
    private boolean rewardedVideoEnable;

    @ApiModelProperty(value = "是否开启返回拦截激励视频")
    private boolean srpVideoEnable;

    @ApiModelProperty(value = "激励视频奖励翻倍倍数")
    private Integer multiple;

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeTitle() {
        return prizeTitle;
    }

    public void setPrizeTitle(String prizeTitle) {
        this.prizeTitle = prizeTitle;
    }

    public String getPrizeFlag() {
        return prizeFlag;
    }

    public void setPrizeFlag(String prizeFlag) {
        this.prizeFlag = prizeFlag;
    }

    public Integer getCurrentRatio() {
        return currentRatio;
    }

    public void setCurrentRatio(Integer currentRatio) {
        this.currentRatio = currentRatio;
    }

    public Integer getTotalRatio() {
        return totalRatio;
    }

    public void setTotalRatio(Integer totalRatio) {
        this.totalRatio = totalRatio;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public boolean isRewardedVideoEnable() {
        return rewardedVideoEnable;
    }

    public void setRewardedVideoEnable(boolean rewardedVideoEnable) {
        this.rewardedVideoEnable = rewardedVideoEnable;
    }

    public boolean isSrpVideoEnable() {
        return srpVideoEnable;
    }

    public void setSrpVideoEnable(boolean srpVideoEnable) {
        this.srpVideoEnable = srpVideoEnable;
    }

    public Integer getMultiple() {
        return multiple;
    }

    public void setMultiple(Integer multiple) {
        this.multiple = multiple;
    }
}
