package cn.com.duiba.tuia.activity.center.api.remoteservice.protogenesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.protogenesis.req.NativeTwiceJoinReq;
import cn.com.duiba.tuia.activity.center.api.dto.protogenesis.twicejoin.NativeBoxRecordDTO;
import cn.com.duiba.tuia.activity.center.api.dto.protogenesis.twicejoin.NativeTwiceJoinDto;
import cn.com.duiba.tuia.activity.center.api.dto.protogenesis.twicejoin.NativeTwiceJoinFinanceDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNativeTwiceJoinService {

    NativeBoxRecordDTO getById(Long id);

    Boolean updateById(NativeBoxRecordDTO nativeBoxRecordDTO);

    List<NativeBoxRecordDTO> listByConsumerId(Long consumerId);

    Long insert(NativeBoxRecordDTO nativeBoxRecordDTO);

    NativeTwiceJoinDto lottery(NativeTwiceJoinReq twiceJoinReq) throws BizException;

    NativeTwiceJoinDto index(NativeTwiceJoinReq twiceJoinReq) throws BizException;

    boolean saveFinanceConfig(NativeTwiceJoinFinanceDTO record);

    int selectUserCount();

    int deleteUser(int limitCount);
}
