/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.client;

import cn.com.duiba.tuia.core.api.client.BaseClient;
import cn.com.duiba.tuia.core.api.constant.RedisKeys;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialCache;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteAdvertMaterialService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.tuia.advert.cache.CacheKeyTool;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AdvertMaterialClient
extends BaseClient {
    @Autowired
    private RemoteAdvertMaterialService remoteAdvertMaterialService;

    public Boolean isNewOfMaterial(Long advertId, Long materialId, Long appId) {
        int status;
        String key = CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId});
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((String)value)) {
            DubboResult<Integer> dubboResult = this.remoteAdvertMaterialService.getNewOldStatus(advertId, materialId, appId);
            if (!dubboResult.isSuccess()) {
                return true;
            }
            status = (Integer)dubboResult.getResult();
        } else {
            try {
                status = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.stringRedisTemplate.delete((Object)key);
                return true;
            }
        }
        return 1 == status;
    }

    public RspMaterialList getMaterialList(Long advertId, Long appId) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K04, advertId, appId}));
        if (StringUtils.isBlank((String)value)) {
            DubboResult<RspMaterialList> dubboResult = this.remoteAdvertMaterialService.updateMaterialList(advertId, appId);
            if (!dubboResult.isSuccess()) {
                return null;
            }
            return (RspMaterialList)dubboResult.getResult();
        }
        return (RspMaterialList)JSONObject.parseObject((String)value, RspMaterialList.class);
    }

    public AdvertMaterialCache getMaterialCache(Long materialId) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K06, materialId}));
        if (StringUtils.isBlank((String)value)) {
            DubboResult<AdvertMaterialCache> dubboResult = this.remoteAdvertMaterialService.updateMaterialCache(materialId);
            if (!dubboResult.isSuccess()) {
                return null;
            }
            return (AdvertMaterialCache)dubboResult.getResult();
        }
        return (AdvertMaterialCache)JSONObject.parseObject((String)value, AdvertMaterialCache.class);
    }
}

