/**
 * Project Name:tuia-core-api<br>
 * File Name:Tag.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:22:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: Tag <br/>
 * Function: 标签. <br/>
 * date: 2016年9月27日 下午7:22:11 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class TagDto extends BaseDto {

    /** The Constant serialVersionUID. */
    private static final long  serialVersionUID         = 1L;

    /** 分类对应的级别. */
    public static final int    LEVEL_OF_CATEGORY        = 0;

    /** 分类的父级ID. */
    public static final int    PARENT_ID_OF_CATEGORY    = 0;

    /** 分类的最大长度. */
    public static final int    CATEGORY_MAX_NAME_LENGTH = 3;

    /** 最大标签层级. */
    public static final int    TAG_MAX_LEVEL            = 2;

    /** 标签(分类)名称. */
    private String             tag;

    /** 标签级别. */
    private Integer            tagLevel;

    /** 标签编码. */
    private String             tagNum;

    /** 父级标签id. */
    private Long               higherId;

    /**
     * The Constructor.
     *
     * @param tag the tag
     * @param tagLevel the tag level
     * @param tagNum the tag num
     */
    public TagDto(String tag, Integer tagLevel, String tagNum) {
        super();
        this.tag = tag;
        this.tagLevel = tagLevel;
        this.tagNum = tagNum;
    }

    /**
     * The Constructor.
     *
     * @param tag the tag
     * @param tagLevel the tag level
     */
    public TagDto(String tag, Integer tagLevel) {
        super();
        this.tag = tag;
        this.tagLevel = tagLevel;
    }

    /**
     * The Constructor.
     */
    public TagDto() {
        super();
    }

    /**
     * Gets the tag.
     *
     * @return the tag
     */
    public String getTag() {
        return tag;
    }

    /**
     * Sets the tag.
     *
     * @param tag the tag
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * Gets the tag level.
     *
     * @return the tag level
     */
    public Integer getTagLevel() {
        return tagLevel;
    }

    /**
     * Sets the tag level.
     *
     * @param tagLevel the tag level
     */
    public void setTagLevel(Integer tagLevel) {
        this.tagLevel = tagLevel;
    }

    /**
     * Gets the tag num.
     *
     * @return the tag num
     */
    public String getTagNum() {
        return tagNum;
    }

    /**
     * Sets the tag num.
     *
     * @param tagNum the tag num
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    /**
     * Gets the higher id.
     *
     * @return the higher id
     */
    public Long getHigherId() {
        return higherId;
    }

    /**
     * Sets the higher id.
     *
     * @param higherId the higher id
     */
    public void setHigherId(Long higherId) {
        this.higherId = higherId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
