/**
 * 文件名： AccountFinanceService.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月14日 下午1:56:31
 */
package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.AccountFinanceDto;
import cn.com.duiba.tuia.core.api.dto.FinanceRecordDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.finance.RechargeApplicationDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAdvertStatisticsDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryAccount;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryFinanceRecord;
import cn.com.duiba.tuia.core.api.dto.rsp.FinanceInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.PspAdvertStatisticsDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspRecharge;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 账号财务记录相关业务 <功能详细描述>.
 *
 * @author: sunjiangrong
 * @创建时间: 2016年4月14日 下午1:56:31
 * @version:
 */
public interface RemoteFinanceBackendService {

    /**
     * 创建资金账户.
     *
     * @param t the t
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> insertAccountFinance(AccountFinanceDto t);

    /**
     * 获取某账号的当日财务信息.
     *
     * @param accountId the account id
     * @param userType  the user type
     * @return the finance
     */
    DubboResult<Map<String, Object>> getFinance(Long accountId, int userType);

    /**
     * 获取代理商的当日财务信息.
     *
     * @param agentId the agent id
     * @return the finance by agent
     */
    DubboResult<Map<String, Object>> getFinanceByAgent(Long agentId);

    /**
     * 修改某账号的账户预算.
     *
     * @param accountId    the account id
     * @param budgetPerDay the budget per day
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAccountBudgetPerDay(Long accountId, Long budgetPerDay);

    /**
     * 账户充值.
     *
     * @param accountId the account id
     * @param amount    the amount
     * @return the dubbo result< rsp recharge>
     */
    DubboResult<RspRecharge> recharge(Long accountId, Long amount);

    /**
     * 代理商根据广告主邮箱地址获取广告主信息.
     *
     * @param agentId      代理商ID
     * @param advertiserId the advertiser id
     * @return 广告主账户信息
     */
    DubboResult<Map<String, Object>> getFinanceInfoByAdvertiserId(Long agentId, long advertiserId);

    /**
     * 代理商获取广告主资金账号列表.
     *
     * @param req the req
     * @return the finance info list
     */
    DubboResult<PageDto<FinanceInfoDto>> getFinanceInfoList(ReqPageQueryAccount req);

    /**
     * 获取自身流水记录.
     *
     * @param req the req
     * @return the finance record list
     */
    DubboResult<PageDto<FinanceRecordDto>> getFinanceRecordList(ReqPageQueryFinanceRecord req);

    /**
     * 代理商获取广告主流水记录.
     *
     * @param agentId the agent id
     * @param req     the req
     * @return the finance record list by agent
     */
    DubboResult<PageDto<FinanceRecordDto>> getFinanceRecordListByAgent(Long agentId, ReqPageQueryFinanceRecord req);

    /**
     * 代理商给广告主充值.
     *
     * @param agentId      the agent id
     * @param advertiserId the advertiser id
     * @param amount       the amount
     * @return the dubbo result< map< string, object>>
     */
    DubboResult<Map<String, Object>> charge(Long agentId, Long advertiserId, Long amount);

    /**
     * 代理商从广告主回拨金额
     *
     * @author chencheng
     * @param agentId
     * @param advertiserId
     * @param amount
     * @return
     */
    DubboResult<Map<String, Object>> callBackToAgent(Long agentId, Long advertiserId, Long amount);
    
    /**
     * 获取某账号的广告统计.
     *
     * @param req the req
     * @return the advert statistics
     */
    DubboResult<PspAdvertStatisticsDto> getAdvertStatistics(ReqGetAdvertStatisticsDto req);

    List<AccountFinanceDto> listByAccountIds(List<Long> accountIds);

    Boolean commitApplication(RechargeApplicationDto applicationDto);
}
