package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.tuia.core.api.dto.advertiser.AccountRechargeRecordDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqPageQueryRechargeRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/21 17:22
 * description: 代理商充值记录服务
 *
 * @since JDK 1.6
 */
public interface RemoteAccountRechargeRecordBackendService {

    /**
     * 增加充值记录
     *
     * @param accountRechargeRecord
     * @return
     */
    DubboResult<Integer> insert(AccountRechargeRecordDto accountRechargeRecord);

    /**
     * 多条件动态组合查询
     *
     * @param req
     * @return
     */
    DubboResult<List<AccountRechargeRecordDto>> selectDynamicSearch(ReqPageQueryRechargeRecordDto req);

    /**
     * 多条件动态组合查询计数
     *
     * @param req
     * @return 查询的记录条数
     */
    DubboResult<Integer> selectDynamicSearchCount(ReqPageQueryRechargeRecordDto req);
}
