package cn.com.duiba.tuia.core.api.remoteservice.permisson;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-08-24 16:53.
 */
public interface RemoteInterfaceUrlService {

    /**
     * 根据id列表获取url列表
     * 
     * @param ids id列表
     * @return url列表
     */
    DubboResult<List<String>> listUrlsByIds(List<Long> ids);

    /**
     * 根据角色列表获取可访问的url列表
     * 
     * @param roleIds 角色id列表
     * @param type 权限类型 1-manager 0-web
     * @return url列表
     */
    DubboResult<List<String>> listUrlsByRoleIds(List<Long> roleIds, Integer type);

    /**
     * 根据角色获取url列表
     * 
     * @param roleId 角色id
     * @param type 角色类型
     * @return url列表
     */
    DubboResult<List<String>> listUrlsByRoleId(Long roleId, Integer type);
}
