package cn.com.duiba.tuia.core.api.remoteservice.permisson;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-08-24 16:53.
 */
public interface RemotePermissionRoleService {

    /**
     * 根据角色id获取permissionId列表
     * 
     * @param roleId 角色id
     * @return permissionId列表
     */
    DubboResult<List<Long>> listPermissionIdsByRoleId(Long roleId);

    /**
     * 根据角色id列表获取permissionId列表
     *
     * @param roleIds 角色id列表
     * @return permissionId列表
     */
    DubboResult<List<Long>> listPermissionIdsByRoleIds(List<Long> roleIds);

    DubboResult<Boolean> deleteByRoleId(Long roleId);

    DubboResult<List<Long>> listPermissionIdsByMenuId(List<Long> menuIds);

    /**
     * 更新角色的权限
     * 
     * @param roleId 角色id
     * @param addPermissionIds 新增的权限
     * @param deletePermissionIds 删除的权限
     * @return 更新结果
     */
    DubboResult<Boolean> updatePermission(Long roleId, List<Long> addPermissionIds, List<Long> deletePermissionIds);

}
