/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class FinanceUtils {
    public static final Long DENOMINATOR = 10000000000L;

    private FinanceUtils() {
    }

    public static BigDecimal getRate(Long rate) {
        return BigDecimal.valueOf(rate).divide(BigDecimal.valueOf(DENOMINATOR), 10, RoundingMode.HALF_UP);
    }

    public static Long getRate(BigDecimal rate) {
        return rate.multiply(BigDecimal.valueOf(DENOMINATOR)).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    public static BigDecimal getRate(Long cashBack, Long totalBalance) {
        return BigDecimal.valueOf(cashBack).divide(BigDecimal.valueOf(totalBalance), 10, RoundingMode.HALF_UP);
    }

    public static Long calculate(Long number, Long rate) {
        return BigDecimal.valueOf(number).multiply(FinanceUtils.getRate(rate)).setScale(0, RoundingMode.HALF_UP).longValue();
    }
}

