/**
 * Project Name:tuia-core-api<br>
 * File Name:DuiBaItemClient.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.client<br>
 * Date:2016年11月11日下午6:21:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.client;

import cn.com.duiba.tuia.core.api.constant.RedisKeys;
import cn.com.duiba.tuia.core.api.constant.TimeFormat;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.tuia.advert.cache.CacheKeyTool;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;
import java.util.concurrent.TimeUnit;

/**
 * ClassName: DuiBaItemClient <br/>
 * Function: 兑吧ItemClient. <br/>
 * date: 2016年11月11日 下午6:21:04 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class DuiBaItemClient extends BaseClient{

    @Autowired
    private RemoteItemService  remoteItemService;

    /**
     * 获取Item关联的广告ID.
     *
     * @param itemId ItemId
     * @return the advert id by itme id
     */
    public Long getAdvertIdByItmeId(long itemId) {
        Long advertId;
        String curDate = new DateTime().toString(TimeFormat.YYYY_MM_DD);

        String strAdvertId = stringRedisTemplate.opsForValue().get(CacheKeyTool.getCacheKey(RedisKeys.K05,curDate,itemId));
        if (StringUtils.isNotBlank(strAdvertId)) {
            advertId = Long.parseLong(strAdvertId);
            return DEFAULT_ID == advertId ? null : advertId;
        } else {
            DubboResult<Long> dubboResult = remoteItemService.getAdvertIdByItmeId(itemId);
            if (!dubboResult.isSuccess()) {
                // 调用失败，返回null
                return null;
            }
            advertId = dubboResult.getResult();
            if(advertId == null){
                stringRedisTemplate.opsForValue().set(CacheKeyTool.getCacheKey(RedisKeys.K05,curDate,itemId),
                                        JSONObject.toJSONString(DEFAULT_ID), DateUtils.getToTomorrowSeconds()+5L, TimeUnit.SECONDS);
                return null;
            }else{
                stringRedisTemplate.opsForValue().set(CacheKeyTool.getCacheKey(RedisKeys.K05,curDate,itemId),
                                        JSONObject.toJSONString(advertId), DateUtils.getToTomorrowSeconds()+5L, TimeUnit.SECONDS);
                return DEFAULT_ID == advertId ? null : advertId;
            }
        }

    }
}
