package cn.com.duiba.tuia.core.api.dto;

import com.google.common.base.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;

public class AdvertLimitDto extends BaseDto {

	private static final long serialVersionUID = -9055767408780966825L;
	
	/** advert表的主键 */
	private Long advertId;
	
	/** 日预算 */
	private Integer dailyBudget;
	
	/** 生效开始时间 */
	private String startDate;
	
	/** 生效结束时间 */
	private String endDate;
	
	/** 周期星期 */
	private String cyclicityWeek;
	
	/** 应用主键 */
	private Long appId;
	
	/** 应用名称 */
	private String appName;
	
	/** 应用账号 */
	private String appAccount;
	
	/** 应用来源 */
	private Integer appSource;
	
	/** 是否存在 */
	private boolean relateStatus;
	
	/**定向包ID*/
	private Long orientPkgId;

	public Long getAdvertId() {
		return advertId;
	}

	public void setAdvertId(Long advertId) {
		this.advertId = advertId;
	}

	public Integer getDailyBudget() {
		return dailyBudget;
	}

	public void setDailyBudget(Integer dailyBudget) {
		this.dailyBudget = dailyBudget;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getCyclicityWeek() {
		return cyclicityWeek;
	}

	public void setCyclicityWeek(String cyclicityWeek) {
		this.cyclicityWeek = cyclicityWeek;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppAccount() {
		return appAccount;
	}

	public void setAppAccount(String appAccount) {
		this.appAccount = appAccount;
	}

	public Integer getAppSource() {
		return appSource;
	}

	public void setAppSource(Integer appSource) {
		this.appSource = appSource;
	}

	public boolean isRelateStatus() {
		return relateStatus;
	}

	public void setRelateStatus(boolean relateStatus) {
		this.relateStatus = relateStatus;
	}

	public Long getOrientPkgId() {
		return orientPkgId;
	}

	public void setOrientPkgId(Long orientPkgId) {
		this.orientPkgId = orientPkgId;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;

		AdvertLimitDto that = (AdvertLimitDto) o;

		if(!Objects.equal(dailyBudget,that.dailyBudget)) return false;
		if(!Objects.equal(startDate,that.startDate)) return false;
		if(!Objects.equal(endDate,that.endDate)) return false;
		if(!Objects.equal(cyclicityWeek,that.cyclicityWeek)) return false;
		if(!Objects.equal(appId,that.appId)) return false;
		if(!Objects.equal(appName,that.appName)) return false;
		if(!Objects.equal(appAccount,that.appAccount)) return false;
		return Objects.equal(appSource,that.appSource);
	}

	@Override
	public int hashCode() {
		int result = dailyBudget != null ? dailyBudget.hashCode() : 0;
		result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
		result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
		result = 31 * result + (cyclicityWeek != null ? cyclicityWeek.hashCode() : 0);
		result = 31 * result + (appId != null ? appId.hashCode() : 0);
		result = 31 * result + (appName != null ? appName.hashCode() : 0);
		result = 31 * result + (appAccount != null ? appAccount.hashCode() : 0);
		result = 31 * result + (appSource != null ? appSource.hashCode() : 0);
		return result;
	}
}
