package cn.com.duiba.tuia.core.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Created by lizhihui on 2017-09-22 15:04. 余额账户计算的一些工具类
 */
public class FinanceUtils {

    private FinanceUtils() {

    }

    // 比率用长整数存储.后八位代表小数点后8位.100 0000 0000
    public static final Long DENOMINATOR = 10000000000L;

    /**
     * 通过整数获取比率
     * @param rate 整数比例
     * @return 比例
     */
    public static BigDecimal getRate(Long rate) {
        return BigDecimal.valueOf(rate).divide(BigDecimal.valueOf(DENOMINATOR), 10, RoundingMode.HALF_UP);
    }

    /**
     * 获取整数类型的比率
     * @param rate 比率
     * @return 整数类型的比率
     */
    public static Long getRate(BigDecimal rate){
        return rate.multiply(BigDecimal.valueOf(DENOMINATOR)).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    /**
     * 获取返货比率
     * @param cashBack 返货金额
     * @param totalBalance 总金额
     * @return 比率
     */
    public static BigDecimal getRate(Long cashBack, Long totalBalance) {
        return BigDecimal.valueOf(cashBack).divide(BigDecimal.valueOf(totalBalance), 10, RoundingMode.HALF_UP);
    }

    /**
     * 计算
     * @param number 整数
     * @param rate 比率
     * @return 计算后的值
     */
    public static Long calculate(Long number, Long rate) {
        return BigDecimal.valueOf(number).multiply(getRate(rate)).setScale(0, RoundingMode.HALF_UP).longValue();
    }
}
