/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertMaterialDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月21日下午2:11:03<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告素材DTO <br/>
 * date: 2016年12月21日 下午2:11:03 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class AdvertMaterialDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.7 */
    private static final long  serialVersionUID   = -3596705396272567507L;

    /** 默认按钮文案. */
    public static final String DEFAULT_BTN_TEXT   = "马上使用";

    /** 默认素材. */
    public static final int    IS_DEFAULT         = 1;

    /** 非默认素材. */
    public static final int    IS_NOT_DEFAULT     = 0;

    /** 激活. */
    public static final int    IS_ACTIVE          = 1;

    /** 屏蔽. */
    public static final int    IS_NOT_ACTIVE      = 0;

    /** 删除状态. */
    public static final int    IS_DELETE          = 1;

    /** 非删除态. */
    public static final int    IS_NOT_DELETE      = 0;

    /** 素材曾激活. */
    public static final int    EVER_ACTIVATED     = 1;

    /** 素材未曾激活. */
    public static final int    EVER_NOT_ACTIVATED = 0;
    /** 提交审核. */
    public static final int    AUDIT_COMMIT = 2;
    /** 审核通过. */
    public static final int    AUDIT_PASS = 0;
    /** 审核拒绝. */
    public static final int    AUDIT_REFUSE = 3;
    /** 新增.*/
    public static final int    AUDIT_NEW = 1;

    /** 广告ID. */
    private Long               advertId;

    /** 默认状态(0：非默认素材， 1：默认素材). */
    private Integer            isDefault;

    /** 激活状态(0：屏蔽， 1：激活). */
    private Integer            isActive;

    /** 审核状态. */
    private Integer            checkStatus;

    /** 商品名称. */
    private String             couponName;

    /** 素材名称. */
    private String             materialName;

    /** 详情页banner图. */
    private String             bannerPng;

    /** 按钮文案. */
    private String             buttonText;

    /** 一句话描述. */
    private String             description;

    /** 素材媒体白名单列表(媒体ID以英文逗号隔开). */
    private String             whiteList;

    /** 素材媒体黑名单列表(媒体ID以英文逗号隔开). */
    private String             blackList;

    /** 删除状态(0：未删除， 1：已删除). */
    private Integer            isDeleted;

    /** 素材是否曾激活（0：未被激活过，1：曾激活过） *. */
    private Integer            everActivated;

    /**
     * materialName.
     *
     * @return the materialName
     * @since JDK 1.7
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * materialName.
     *
     * @param materialName the materialName to set
     * @since JDK 1.7
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the is deffault.
     *
     * @return the checks if is deffault
     */
    public Integer getIsDefault() {
        return isDefault;
    }

    /**
     * Sets the is deffault.
     *
     * @param isDefault the checks if is deffault
     */
    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    /**
     * Gets the is shield.
     *
     * @return the checks if is shield
     */
    public Integer getIsActive() {
        return isActive;
    }

    /**
     * Sets the is shield.
     *
     * @param isActive the checks if is active
     */
    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    /**
     * Gets the coupon name.
     *
     * @return the coupon name
     */
    public String getCouponName() {
        return couponName;
    }

    /**
     * Sets the coupon name.
     *
     * @param couponName the coupon name
     */
    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    /**
     * Gets the banner png.
     *
     * @return the banner png
     */
    public String getBannerPng() {
        return bannerPng;
    }

    /**
     * Sets the banner png.
     *
     * @param bannerPng the banner png
     */
    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    /**
     * Gets the button text.
     *
     * @return the button text
     */
    public String getButtonText() {
        return buttonText;
    }

    /**
     * Sets the button text.
     *
     * @param buttonText the button text
     */
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    /**
     * Gets the content.
     *
     * @return the content
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the content.
     *
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * Gets the white list.
     *
     * @return the white list
     */
    public String getWhiteList() {
        return whiteList;
    }

    /**
     * Sets the white list.
     *
     * @param whiteList the white list
     */
    public void setWhiteList(String whiteList) {
        this.whiteList = whiteList;
    }

    /**
     * Gets the black list.
     *
     * @return the black list
     */
    public String getBlackList() {
        return blackList;
    }

    /**
     * Sets the black list.
     *
     * @param blackList the black list
     */
    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    /**
     * Gets the ever activated.
     *
     * @return the ever activated
     */
    public Integer getEverActivated() {
        return everActivated;
    }

    /**
     * Sets the ever activated.
     *
     * @param everActivated the ever activated
     */
    public void setEverActivated(Integer everActivated) {
        this.everActivated = everActivated;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
}
