package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.advertiser.AccountFinanceStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.req.account.AccountFinanceStatisticsQueryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/21 15:47 description: 财务记录每日统计汇总服务
 *
 * @since JDK 1.6
 */
public interface RemoteAccountFinanceStatisticsDayService {

    /**
     * 添加财务记录每日统计汇总记录
     *
     * @param accountFinanceStatisticsDay 所有参数均为必传
     * @return
     */
    DubboResult<Integer> addAccountFinanceStatisticsDay(AccountFinanceStatisticsDayDto accountFinanceStatisticsDay);

    /**
     * 查询财务记录每日统计汇总记录
     *
     * @param accountId 代理商或者广告主id 必传
     * @param type 交易类型:(10：账号充值; 11:平台退款; 12:代理商划账; 13:赠送金额; 14:线上充值;20:广告扣费; 21: 扣除金额; 22:代理商划账) 必传
     * @return
     */
    DubboResult<AccountFinanceStatisticsDayDto> getFinanceStatisticsDay(Long accountId, int type);

    /**
     * 更新财务记录每日统计汇总记录
     *
     * @param accountFinanceStatisticsDay curDate、accountId和type必传
     * @return
     */
    DubboResult<Integer> updateFinanceStatisticsDay(AccountFinanceStatisticsDayDto accountFinanceStatisticsDay);

    List<AccountFinanceStatisticsDayDto> list(AccountFinanceStatisticsQueryDto queryDto);

    List<AccountFinanceStatisticsDayDto> gatherList(AccountFinanceStatisticsQueryDto queryDto);

    int count(AccountFinanceStatisticsQueryDto queryDto);
}
