/**
 * 文件名： AdvertStatisticsDayModel.java 此类描述的是： 作者: zufengze 创建时间: 2016年3月24日 下午3:35:16
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 广告统计数据.
 *
 * @author: zufengze
 * @创建时间: 2016年4月21日 下午3:35:16
 * @version:
 */
public class AdvertStatisticsRsp extends AdvertStatisticsData {

    private static final long         serialVersionUID = -1837740607725655427L;

    /** 广告ID. */
    private Long                      id;

    /** 广告名称. */
    private String                    advertName;

    /** The billing count. */
    private Long                      billingCount;

    /** 广告主ID. */
    private Long                      advertiserId;

    /** 广告主名称. */
    private String                    companyName;

    /** 代理商名称. */
    private String                    agentCompanyName;

    /** 广告关联的兑换券信息. */
    private List<AdvertStatisticsRsp> children;

    /** 当前日期. */
    private Date                      curDate;

    /** 实际消费 */
    private BigDecimal                correctionTotal;

    /** AE名称 */
    private String                    aeName;

    /** 销售名称 */
    private String                    sellName;

    /** 资源名称 */
    private String                    resourceName;

    /** 行业名称 */
    private String                    tradeName;

    /** 广告状态 @{AdvertValidStatusEnum} */
    private Integer                   validStatus;

    /** 广告状态名称，用于页面展示 */
    private String                    validStatusName;

    /** 预算 */
    private Long                      budget;

    //ctr诊断结果，如：好、差、一般、很差、不确定等
    private String                    diagnosticResultCtr;

    //ctr诊断的详细内容
    private String                    comDiagnosticContentCtr;

    //cvr诊断结果，如：好、差、一般、很差、不确定等
    private String                    diagnosticResultCvr;

    //cvr诊断的详细内容
    private String                    comDiagnosticContentCvr;

    public String getDiagnosticResultCtr() {
        return diagnosticResultCtr;
    }

    public void setDiagnosticResultCtr(String diagnosticResultCtr) {
        this.diagnosticResultCtr = diagnosticResultCtr;
    }

    public String getComDiagnosticContentCtr() {
        return comDiagnosticContentCtr;
    }

    public void setComDiagnosticContentCtr(String comDiagnosticContentCtr) {
        this.comDiagnosticContentCtr = comDiagnosticContentCtr;
    }

    public String getDiagnosticResultCvr() {
        return diagnosticResultCvr;
    }

    public void setDiagnosticResultCvr(String diagnosticResultCvr) {
        this.diagnosticResultCvr = diagnosticResultCvr;
    }

    public String getComDiagnosticContentCvr() {
        return comDiagnosticContentCvr;
    }

    public void setComDiagnosticContentCvr(String comDiagnosticContentCvr) {
        this.comDiagnosticContentCvr = comDiagnosticContentCvr;
    }

    /**
     * validStatusName.
     *
     * @return the validStatusName
     * @since JDK 1.8
     */
    public String getValidStatusName() {
        return validStatusName;
    }

    /**
     * validStatusName.
     *
     * @param validStatusName the validStatusName to set
     * @since JDK 1.8
     */
    public void setValidStatusName(String validStatusName) {
        this.validStatusName = validStatusName;
    }

    /**
     * budget.
     *
     * @return the budget
     * @since JDK 1.8
     */
    public Long getBudget() {
        return budget;
    }

    /**
     * budget.
     *
     * @param budget the budget to set
     * @since JDK 1.8
     */
    public void setBudget(Long budget) {
        this.budget = budget;
    }

    /**
     * validStatus.
     *
     * @return the validStatus
     * @since JDK 1.8
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * validStatus.
     *
     * @param validStatus the validStatus to set
     * @since JDK 1.8
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the advertiser id.
     *
     * @return the advertiser id
     */
    public Long getAdvertiserId() {
        return advertiserId;
    }

    /**
     * Sets the advertiser id.
     *
     * @param advertiserId the advertiser id
     */
    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    /**
     * Gets the advert name.
     *
     * @return the advertName
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * Sets the advert name.
     *
     * @param advertName the advertName to set
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * Gets the billing count.
     *
     * @return the billingCount
     */
    public Long getBillingCount() {
        return billingCount;
    }

    /**
     * Sets the billing count.
     *
     * @param billingCount the billingCount to set
     */
    public void setBillingCount(Long billingCount) {
        this.billingCount = billingCount;
    }

    /**
     * Gets the children.
     *
     * @return the children
     */
    public List<AdvertStatisticsRsp> getChildren() {
        return children;
    }

    /**
     * Sets the children.
     *
     * @param children the children
     */
    public void setChildren(List<AdvertStatisticsRsp> children) {
        this.children = children;
    }

    /**
     * Gets the companyName.
     *
     * @return the companyName
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Sets the companyName.
     *
     * @param companyName the companyName to set
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Gets the agentCompanyName.
     *
     * @return the agentCompanyName
     */
    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    /**
     * Sets the agentCompanyName.
     *
     * @param agentCompanyName the agentCompanyName to set
     */
    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public BigDecimal getCorrectionTotal() {
        return correctionTotal;
    }

    public void setCorrectionTotal(BigDecimal correctionTotal) {
        this.correctionTotal = correctionTotal;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getTradeName() {
        return tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
