/**
 * Project Name:tuia-core-api<br>
 * File Name:AccountType.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.constant<br>
 * Date:2016年8月23日上午11:12:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.constant;

/**
 * ClassName: AccountType <br/>
 * Function: 用户类型. <br/>
 * date: 2016年8月23日 上午11:12:36 <br/>
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 */
public enum AccountType {

    /** 广告主. */
    ADVERTISER(0),

    /** 协作员. */
    EMPLOYEE(1),

    /** 代理商. */
    AGENT(2),

    /** 系统管理员. */
    ADMINISTRATOR(3);
    
    /** 用户类型. */
    private int userType;

    /**
     * The Constructor.
     */
    private AccountType() {
    }

    /**
     * The Constructor.
     *
     * @param accountType the account type
     * @param remark the remark
     */
    private AccountType(int userType) {
        this.userType = userType;
    }

    /**
     * Gets the account type.
     *
     * @return the account type
     */
    public int getAccountType() {
        return userType;
    }

}
