/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteLoadPageHourEffectStatisticsService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.statistics
 * Date:2017年8月26日下午4:52:57
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.req.data.ReqLoadingPageHourEffectDto;
import cn.com.duiba.tuia.core.api.dto.rsp.landingPage.RspLoadingPageHourEffectDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteLoadPageHourEffectStatisticsService <br/>
 * Function: 落地页小时维度离线数据查询. <br/>
 * Date:     2017年8月26日 下午4:52:57 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface RemoteLoadPageHourEffectStatisticsService {
    /**
     * 
     * listTotalByAdvertIdsAndDate:(落地页小时维度离线数据查询). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<List<RspLoadingPageHourEffectDto>> selectLandingPageHourData(ReqLoadingPageHourEffectDto dto);
    
    /**
     * 
     * countLandingPageHourData:(落地页小时维度离线数据总计). <br/>
     *
     * @author chencheng
     * @param entity
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<Integer> countLandingPageHourData(ReqLoadingPageHourEffectDto dto);
}

