package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: ResourceTagsTypeEnum <br/>
 * Function: 资源对应标签类型. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum ResourceTagsTypeEnum {

    /** 广告推广链接标签 */
    AD("ad", "广告推广链接标签"),

    /** 素材标签 */
    MATERIAL("material", "素材标签");

    private String desc;

    private String code;

    ResourceTagsTypeEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, ResourceTagsTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (ResourceTagsTypeEnum it : ResourceTagsTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static ResourceTagsTypeEnum getByName(String code) {
        return enumMap.get(code);
    }
}
