package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.core.api.dto.AdvertOrientationPackageDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertChargeDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertOrientationPackageBudgetPerDayDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

public interface RemoteAdvertOrientPackageBackendService {

	/**
	 * 根据广告ID查询定向投放配置包
	 * @param advertId 广告ID
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<AdvertOrientationPackageDto>> getAdvertOrientationPackage(Long advertId);
	
	/**
	 * 新增或者复制定向配置包
	 * @param dto 返回定向配置包的自增ID
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Long> addAvertOrientationPackage(AdvertOrientationPackageDto dto);
	
	/**
	 * 根据定向包ID更新定向包的启用状态
	 * @param enableStatus
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateAdvertOrientPackageEnableStatus(Integer enableStatus, Long id);
	
	/**
	 * 保存对定向配置包的修改
	 * @param dto
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Boolean> updateAdvertOrientPackage(AdvertOrientationPackageDto dto);
	
	/**
     * 广告单价查询
     * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
     * @param advertId 广告ID
     * @param advertOrientPackageId 配置包ID
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getFeeByAdvertId(Long advertId, Long advertOrientPackageId);

	/**
	 * 广告单价查询
	 * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
	 * @param advertIds 广告ID
	 * @return
	 */
	DubboResult<Map<Long,Long>> getFeeByAdvertIds(List<Long> advertIds);

	/**
	 * 点击单价和转化出价查询
	 * advertOrientPackageId若为null,则根据advertId查询,不为null,两者组合查
	 * @param advertId 广告ID
	 * @param advertOrientPackageId 配置包ID
	 * @return
	 * @throws TuiaCoreException
	 * @since JDK 1.6
	 */
	DubboResult<List<RspAdvertChargeDto>> getFeeAndCpaFeeByAdvertId(Long advertId, Long advertOrientPackageId);
	
	/**
	 * 根据广告ID查询默认定向包信息
	 * @param advertId
	 * @return
	 * @throws TuiaCoreException
	 * @since JDK 1.6
	 */
	DubboResult<AdvertOrientationPackageDto> selectDefaultByAdvertId(Long advertId);
	
	/**
	 * 修改定向配置名称
	 *
	 * @param packageName 定向配置名称
	 * @param id 定向配置id
	 * @author chencheng
	 * @return
	 */
	DubboResult<Integer> updateAdvertOrientPackageName(String packageName, Long id);
	
	/**
	 * 修改定向配置每日预算
	 *
	 * @param packageName 定向配置每日预算
	 * @param id 定向配置id
	 * @author chencheng
	 * @return
	 */
	DubboResult<Integer> updateAdvertOrientPackageBudget(Long budgetPerDay, Long id);
	
	/**
     * 根据广告ID查询定向配置包每日预算
     * @param advertId 广告ID
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspAdvertOrientationPackageBudgetPerDayDto>> getAdvertOrientationPackageBudget(Long advertId);
    
    /**
     * 根据定向配置ID查询定向投放配置
     * @param advertOrientPackageId 定向配置ID
     * @return
     * @since JDK 1.6
     */
    DubboResult<AdvertOrientationPackageDto> selectById(Long advertOrientPackageId);

	/**
	 * 根据广告ID批量查询定向信息
	 * @param advertIds
	 * @return
	 */
	DubboResult<List<AdvertOrientationPackageDto>> listAdvertOrientationPackageByAdvertIds(List<Long> advertIds);
	
	/**
	 * 
	 * batchUpdate:(批量更新定向配置). <br/>
	 *
	 * @author chencheng
	 * @param list
	 * @return
	 * @throws TuiaCoreException 
	 * @since JDK 1.8
	 */
	Boolean batchUpdateOrientationPackage(List<AdvertOrientationPackageDto> list) throws Exception;
}
