/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年8月19日下午4:22:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.AdvertCheckRecordDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDetailDto;
import cn.com.duiba.tuia.core.api.dto.AdvertDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAdvertIds;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetCreateAdvertDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryAdverts;
import cn.com.duiba.tuia.core.api.dto.req.ReqUpdateAdvertPlanDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqUpdateCouponDto;
import cn.com.duiba.tuia.core.api.dto.rsp.AdvertPageContrastDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspInsertCouponFileDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;

/**
 * ClassName: RemoteLandPagePatrolService <br/>
 * Function: 落地页巡查. <br/>
 * date: 2017年7月29日 下午4:22:04 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.8
 */
public interface RemoteLandPagePatrolService {
/**
 *  * @Description: selectVaildList 查询需要巡查的广告计划列表
     *
     * @Param: []
     * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.core.api.dto.rsp.AdvertPageContrastDto>>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/27
     */
    DubboResult<List<AdvertPageContrastDto>> selectVaildList();

    /***
         * @Description: batchSaveConstrast 保存对比记录
         *  没有id则新增记录 否则更新已有的对比记录
         * @Param: [recordList]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Integer>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/7/27
         */
    DubboResult<Integer> saveConstrast(AdvertPageContrastDto record);

    /***
         * @Description: updateConstrast 更新某一条对比记录
         *
         * @Param: [recordList]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Integer>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/7/27
         */
    DubboResult<Integer> updateConstrast(AdvertPageContrastDto recordList);

}
