package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertTargetAppDetail;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

public class AdvertOrientationPackageDto extends BaseDto {

    /** 非默认定向包 */
    public static final int           NOTISDEFAULT     = 0;
    /** 默认定向包 */
    public static final int           DEFAULT_PACKAGE  = 1;
    public static final int           ISENABLE         = 1;
    public static final String        DEFAULT_NAME     = "默认";
    private static final long         serialVersionUID = -4515037621723222896L;
    /** 广告主键 */
    private Long                      advertId;

    /** 定向包名称 */
    private String                    packageName;

    /** 计费方式 */
    private Integer                   chargeType;

    /** 广告出价.1：CPC;2：CPA */
    private Long                      fee;

    /** 转化出价(分). */
    private Long                      cpaFee;

    /** 操作系统 */
    private String                    platform;

    /** 投放区域 */
    private String                    regionIds;

    /** 启用状态:1-启用;0-暂停 */
    private Integer                   enableStatus;

    /** 设备价值 */
    private String                    phoneLevel;

    /** 定向投放次数(发券顺序) */
    private String                    directionalNum;

    /**
     * 是否是默认值：0 否 1 是
     */
    private Integer                   isDefault;

    /**
     * 网络类型：1、WIFI；2、3G；3、4G；4、其他
     */
    private String                    networkType;

    /**
     * 运营商：1、移动；2、联通；3、电信；4、其他
     */
    private String                    operators;

    /**
     * 年龄区间
     */
    private String                    ageRegion;

    /**
     * 性别：1 男 2 女
     */
    private String                    sex;

    /** 投放时段 */
    private List<AdvertPlanPeriodDto> periods;
    /** 广告屏蔽标签 */

    private String                         bannedTagNums;
    /** 定向媒体列表详情 */

    private List<RspAdvertTargetAppDetail> targetApp;
    /** 定向媒体appId */
    private String                         targetAppIds;
    /** 限流媒体 */
    private List<AdvertLimitDto>           advertLimit;
    /** 每日预算. */
    private Long                           budgetPerDay;
    /** 限流媒体 */
    private String                         limitAppIds;
    public AdvertOrientationPackageDto(String packageName) {
        this.packageName = packageName;
    }

    public AdvertOrientationPackageDto() {
    }

    public String getLimitAppIds() {
        return limitAppIds;
    }

    public void setLimitAppIds(String limitAppIds) {
        this.limitAppIds = limitAppIds;
    }

    /**
     * budgetPerDay.
     *
     * @return the budgetPerDay
     */
    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * budgetPerDay.
     *
     * @param budgetPerDay the budgetPerDay to set
     */
    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    /**
     * cpaFee.
     *
     * @return the cpaFee
     */
    public Long getCpaFee() {
        return cpaFee;
    }

    /**
     * cpaFee.
     *
     * @param cpaFee the cpaFee to set
     */
    public void setCpaFee(Long cpaFee) {
        this.cpaFee = cpaFee;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(String regionIds) {
        this.regionIds = regionIds;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getPhoneLevel() {
        return phoneLevel;
    }

    public void setPhoneLevel(String phoneLevel) {
        this.phoneLevel = phoneLevel;
    }

    public String getDirectionalNum() {
        return directionalNum;
    }

    public void setDirectionalNum(String directionalNum) {
        this.directionalNum = directionalNum;
    }

    public List<AdvertPlanPeriodDto> getPeriods() {
        return periods;
    }

    public void setPeriods(List<AdvertPlanPeriodDto> periods) {
        this.periods = periods;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getNetworkType() {
        return networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getOperators() {
        return operators;
    }

    public void setOperators(String operators) {
        this.operators = operators;
    }

    public String getAgeRegion() {
        return ageRegion;
    }

    public void setAgeRegion(String ageRegion) {
        this.ageRegion = ageRegion;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getBannedTagNums() {
        return bannedTagNums;
    }

    public void setBannedTagNums(String bannedTagNums) {
        this.bannedTagNums = bannedTagNums;
    }

    public List<RspAdvertTargetAppDetail> getTargetApp() {
        return targetApp;
    }

    public void setTargetApp(List<RspAdvertTargetAppDetail> targetApp) {
        this.targetApp = targetApp;
    }

    public List<AdvertLimitDto> getAdvertLimit() {
        return advertLimit;
    }

    public void setAdvertLimit(List<AdvertLimitDto> advertLimit) {
        this.advertLimit = advertLimit;
    }

    public String getTargetAppIds() {
        return targetAppIds;
    }

    public void setTargetAppIds(String targetAppIds) {
        this.targetAppIds = targetAppIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
