/**
 * 文件名： AccountfinancialDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月8日 上午11:54:14
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告主资金账户.
 *
 * @author: leiliang
 * @version:
 */
public class AccountFinanceDto extends BaseDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 1870427718680736084L;

    /** 账户ID. */
    private Long              accountId;

    /** 账号余额. */
    private Long              balance;

    /** 每日预算. */
    private Long              budgetPerDay;

    /** 返货比率. */
    private Long              cashBackRate;

    public Long getCashBackRate() {
        return cashBackRate;
    }

    public void setCashBackRate(Long cashBackRate) {
        this.cashBackRate = cashBackRate;
    }

    /**
     * Gets the account id.
     *
     * @return the account id
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * Sets the account id.
     *
     * @param accountId the account id
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * Gets the balance.
     *
     * @return the balance
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * Sets the balance.
     *
     * @param balance the balance
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    /**
     * Gets the budget per day.
     *
     * @return the budget per day
     */
    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * Sets the budget per day.
     *
     * @param budgetPerDay the budget per day
     */
    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
