/*
 * 17-5-24 下午2:02
 * Administrator
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

/**
 * ClassName: AdvertPlanPeriodDO <br/>
 * Function: 投放时段. <br/>
 * date: 2016年7月8日 上午10:23:14 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class AdvertPlanPeriodEsDto implements Serializable {
	
    private static final long serialVersionUID = 1L;


    private Long              id;

    /** 时段开始时间. */
    private String            startHour;

    /** 时段结束时间. */
    private String            endHour;

    /** 投放上限.,使用periodValue 8.4号后可删除此字段*/
    @Deprecated
    private Integer           launchLimit;
    /** 广告ID. */
    private Long              advertId;

    /** 定向配置包ID */
    private Long              advertPackageId;

    /**投放时段类型   tuia-core@AdvertPkgPeriodTypeEnum*/
    private String periodType;
    /**投放时段值  value ="hourCoupon" 则当前值是 "每小时发券量" or value="countCoupon" 总发券量 or value="hourBudget"每小时预算 or value="countBudget"总预算*/
    private Long periodValue;

    public AdvertPlanPeriodEsDto(Long id, String startHour, String endHour, Integer launchLimit, Long advertId, Long advertPackageId,String periodType,Long periodValue) {
        this.id = id;
        this.startHour = startHour;
        this.endHour = endHour;
        this.launchLimit = launchLimit;
        this.advertId = advertId;
        this.advertPackageId = advertPackageId;
        this.periodType = periodType;
        this.periodValue = periodValue;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertPackageId() {
        return advertPackageId;
    }

    public void setAdvertPackageId(Long advertPackageId) {
        this.advertPackageId = advertPackageId;
    }



    /**
     * startHour.
     *
     * @return the startHour
     * @since JDK 1.7
     */
    public String getStartHour() {
        return startHour;
    }

    /**
     * startHour.
     *
     * @param startHour the startHour to set
     * @since JDK 1.7
     */
    public void setStartHour(String startHour) {
        this.startHour = startHour;
    }

    /**
     * endHour.
     *
     * @return the endHour
     * @since JDK 1.7
     */
    public String getEndHour() {
        return endHour;
    }

    /**
     * endHour.
     *
     * @param endHour the endHour to set
     * @since JDK 1.7
     */
    public void setEndHour(String endHour) {
        this.endHour = endHour;
    }

    /**
     * launchLimit.
     *
     * @return the launchLimit
     * @since JDK 1.7
     */
    public Integer getLaunchLimit() {
        return launchLimit;
    }

    /**
     * launchLimit.
     *
     * @param launchLimit the launchLimit to set
     * @since JDK 1.7
     */
    public void setLaunchLimit(Integer launchLimit) {
        this.launchLimit = launchLimit;
    }

    public String getPeriodType() {
        return periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public Long getPeriodValue() {
        return periodValue;
    }

    public void setPeriodValue(Long periodValue) {
        this.periodValue = periodValue;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertPlanPeriodDto [advertId=");
        builder.append(", startHour=");
        builder.append(startHour);
        builder.append(", endHour=");
        builder.append(endHour);
        builder.append(", launchLimit=");
        builder.append(launchLimit);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
