/**
 * 文件名： accountFinanceRecord.java 此类描述的是： 作者: zufengze 创建时间: 2016年4月19日
 * 下午2:06:42
 */
package cn.com.duiba.tuia.core.api.dto.advertiser;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 账户资金流水记录
 *
 * @author: huangch
 * @version:
 */
public class AccountFinanceRecordDto extends BaseDto {

    private static final long serialVersionUID = 912829040442227069L;

    /**
     * 广告主账户ID
     */
    private Long accountId;

    /**
     * 广告主账户资金表ID
     */
    private Long financeId;

    /**
     * 广告主账户余额
     */
    private Long balance;

    /**
     * 广告主账户入账金额
     */
    private Long balanceIn;

    /**
     * 广告主账户支出金额
     */
    private Long balanceOut;

    /**
     * 广告主账户资金流动类型 记录方式:AB,A位1存入,2支出;10-充值;11-退款等;20-广告扣费
     */
    private Integer recordType;

    /**
     * 广告主账户资金流动备注
     */
    private String remark;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getFinanceId() {
        return financeId;
    }

    public void setFinanceId(Long financeId) {
        this.financeId = financeId;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getBalanceIn() {
        return balanceIn;
    }

    public void setBalanceIn(Long balanceIn) {
        this.balanceIn = balanceIn;
    }

    public Long getBalanceOut() {
        return balanceOut;
    }

    public void setBalanceOut(Long balanceOut) {
        this.balanceOut = balanceOut;
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
