/**
 * Project Name:tuia-core-api<br>
 * File Name:RsqGetEmployeesByPage.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp<br>
 * Date:2016年9月7日下午4:04:33<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.EmployeeDto;

/**
 * ClassName: RsqGetEmployeesByPage <br/>
 * Function: 分页查询协作员相应. <br/>
 * date: 2016年9月7日 下午4:04:33 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RsqGetEmployeesByPage implements Serializable {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 317538910839866748L;

    /** 协作员列表. */
    private List<EmployeeDto> employees;

    /** 查询总数. */
    private int               totalQueryNum;

    /** 所有已启用账号总数. */
    private int               totalNum;

    /** 启用的操作者总数. */
    private int               operatorNum;

    /**
     * The Constructor.
     *
     * @param totalNum the total num
     * @param operatorNum the operator num
     */
    public RsqGetEmployeesByPage(int totalNum, int operatorNum) {
        super();
        this.totalNum = totalNum;
        this.operatorNum = operatorNum;
    }

    /**
     * The Constructor.
     */
    public RsqGetEmployeesByPage() {
        super();
    }

    /**
     * Gets the employees.
     *
     * @return the employees
     */
    public List<EmployeeDto> getEmployees() {
        return employees;
    }

    /**
     * Sets the employees.
     *
     * @param employees the employees
     */
    public void setEmployees(List<EmployeeDto> employees) {
        this.employees = employees;
    }

    /**
     * Gets the total query num.
     *
     * @return the total query num
     */
    public int getTotalQueryNum() {
        return totalQueryNum;
    }

    /**
     * Sets the total query num.
     *
     * @param totalQueryNum the total query num
     */
    public void setTotalQueryNum(int totalQueryNum) {
        this.totalQueryNum = totalQueryNum;
    }

    /**
     * Gets the total num.
     *
     * @return the total num
     */
    public int getTotalNum() {
        return totalNum;
    }

    /**
     * Sets the total num.
     *
     * @param totalNum the total num
     */
    public void setTotalNum(int totalNum) {
        this.totalNum = totalNum;
    }

    /**
     * Gets the operator num.
     *
     * @return the operator num
     */
    public int getOperatorNum() {
        return operatorNum;
    }

    /**
     * Sets the operator num.
     *
     * @param operatorNum the operator num
     */
    public void setOperatorNum(int operatorNum) {
        this.operatorNum = operatorNum;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
