/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteStatisticsAdvertiserBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年9月5日下午3:46:54<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.*;
import cn.com.duiba.tuia.core.api.dto.req.ReqAccountStatisticsDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAccountStatisticsDataDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryAdverts;
import cn.com.duiba.tuia.core.api.dto.rsp.RspGetAccountStasByPage;
import cn.com.duiba.tuia.core.api.dto.statistics.AdvertDataByHourDto;
import cn.com.duiba.tuia.core.api.dto.statistics.req.ReqQueryDataByHourDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName: RemoteStatisticsAdvertiserBackendService <br/>
 * date: 2016年9月5日 下午3:46:54 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public interface RemoteStatisticsBackendService {

    /**
     * 分页查询广告主列表及总数.
     *
     * @param req the req
     * @return the dubbo result< rsq get employees by page>
     */
    DubboResult<RspGetAccountStasByPage> selectListByPage(ReqGetAccountStatisticsDataDto req);

    /**
     * 查询分页广告主列表.
     *
     * @param req the req
     * @return the dubbo result< list< account statistics day dto>>
     */
    DubboResult<List<AccountStatisticsDayDto>> pageQuery(ReqGetAccountStatisticsDataDto req);

    /**
     * 分页查询总数量.
     *
     * @param req the req
     * @return the dubbo result< integer>
     */
    DubboResult<Integer> pageQueryAmount(ReqGetAccountStatisticsDataDto req);

    /**
     * 查询账户首页统计数据.
     *
     * @param req 请求参数
     * @return 账户首页统计信息
     */
    DubboResult<AdvertStatisticsFinanceDto> getAccountStatistics(ReqAccountStatisticsDto req);

    /**
     * 广告列表排序-分页查询广告统计数据.
     *
     * @param req the req
     * @param advertIds the advert ids
     * @return the page advert data list
     */
    DubboResult<PageDto<AdvertStatisticsDayDto>> getPageAdvertDataList(ReqPageQueryAdverts req, List<Long> advertIds);

    /**
     * 通过advertIds集合去广告数据统计表中查询出统计信息.
     *
     * @param startDate the start date
     * @param endDate the end date
     * @param advertIds the advert ids
     * @return the duiaba item statistics data by ids
     */
    DubboResult<List<AdvertStatisticsDayDto>> getDuiabaItemStatisticsDataByIds(String startDate, String endDate,
                                                                               List<Long> advertIds);

    /**
     * 通过advertIds集合去广告数据统计表中查询出统计信息.
     *
     * @param startDate the start date
     * @param endDate the end date
     * @param advertIds the advert ids
     * @param exportType 0 or null ：汇总，1：分日
     * @return the duiaba item statistics data by ids
     */
    DubboResult<List<AdvertStatisticsDayDto>> getDuiabaItemStatisticsDataByIds(String startDate, String endDate,
                                                                                         List<Long> advertIds,Integer exportType);
    /**
     * 通过广告ID去统计表查询关联兑换券每小时数据信息.
     *
     * @param curDate the cur date
     * @param advertId the advert id
     * @return the item hour data by advert id
     */
    DubboResult<List<AdvertStatisticsDayDto>> getItemHourDataByAdvertId(String curDate, Long advertId);

    /**
     * 通过广告ID去统计表查询关联兑换券每小时数据信息.
     *
     * @param curDate the cur date
     * @param advertId the advert id
     * @param exportType 0 or null ：汇总，1：分日
     * @return the item hour data by advert id
     *
     */
    DubboResult<List<AdvertStatisticsDayDto>> getItemHourDataByAdvertId(String curDate, Long advertId,Integer exportType);
    
    /**
     * 通过广告ID去统计表查询关联兑换券每小时数据信息.
     *
     * @param curDate the cur date
     * @param advertId the advert id
     * @param exportType 0 or null ：汇总，1：分日
     * @return the item hour data by advert id
     *
     */
    DubboResult<List<AdvertStatisticsDayDto>> getItemHourDataByAdvertId(String startDate, String endDate, Long advertId,Integer exportType);

    /**
     * 查询广告分时数据总(条)数.
     *
     * @param req
     * @return
     */
    DubboResult<Integer> selectDataAmount(ReqQueryDataByHourDto req);

    /**
     * 查询广告分时数据.
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertDataByHourDto>> selectData(ReqQueryDataByHourDto req);

    /**
     * 根据日期查询不同领券次数的数据信息
     *
     * @param startDate
     * @param endDate
     * @param advertId
     * @return
     */
    DubboResult<List<AdvertStatisticsDayTimesDto>> getLaunchedTimes(String startDate, String endDate, Long advertId);

    /**
     * 根据日期统计,某广告不同方式的发券统计信息
     */
    DubboResult<List<AdvertDifferentWayStatisticsDto>> getDifferentWayByAdvertId(String startDate, String endDate, Long advertId);
}
