
/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteSystemConfigBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年8月23日下午3:31:42<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 *
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.SystemConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: RemoteSystemConfigBackendService <br/>
 * Function: 系统配置模块. <br/>
 * date: 2016年8月23日 下午3:31:42 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public interface RemoteSystemConfigBackendService {

	/**
     * 查询对应key值的类. <br/>
     *
     * @param tuiaKey the tuia key
     * @return the system config
     * @author sunjiangrong
     * @since JDK 1.6
     */
    DubboResult<SystemConfigDto> getSystemConfig(String tuiaKey);
    
    /**
     * 更新配置项信息
     * @param config
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateSystemConfig(SystemConfigDto config);
}

