package cn.com.duiba.tuia.core.api.remoteservice.app;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.AppFlowStrategyDto;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqPageQueryAppFlowStrategyData;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppFlowStrategyPage;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppFlowStrategyTypeDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspEngineAppFlowStrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * 新媒体策略配置
 * date: 2017年3月10日 下午2:31:05 <br/>
 *
 * @author chencheng
 * @version
 */
public interface RemoteAppFlowStrategyService {
    /**
     * 根据id查询新媒体策略
     *
     * @param strategyId 配置id
     * @return
     */
    DubboResult<AppFlowStrategyDto> findAppFlowStrategyById(Long strategyId);
    
    /**
     * 根据id查询新媒体策略,返回AppFlowStrategyDto
     *
     * @param strategyId 配置id
     * @return
     */
    DubboResult<AppFlowStrategyDto> findAppFlowStrategyDtoByAppId(Long appId);
   
    /**
     * 根据应用id查询新媒体策略，返回Engine需求的数据
     *
     * @param appId appId
     * @return
     */
    DubboResult<RspEngineAppFlowStrategyDto> findAppFlowStrategyByAppId(Long appId);
 
    /**
     * 插入媒体流量策略
     *
     * @param RspAppFlowStrategyTypeDto entity
     */
    DubboResult<Boolean> insertOrUpdateAppFlowStrategy(AppFlowStrategyDto entity);
 
 
    /**
     * 更新媒体策略启用状态
     *
     * @param strategyId 策略id
     * @param status 启用状态
     */
    DubboResult<Integer> changeEnableState(Long strategyId,int status);
 
    /**
     * 更新媒体策略福袋开启状态
     *
     * @param strategyId 策略id
     * @param status 启用状态
     * @return
     */
    DubboResult<Integer> changeLuckyStatus(Long strategyId,int status);
    
    /**
     * 查询新媒体策略状态
     *
     * @param appIds 媒体Id
     * @return
     */
    DubboResult<List<RspAppFlowStrategyTypeDto>> selectAppFlowStrategyType(List<Long> appIds);
    
    /**
     * 查询总数
     *
     * @author chencheng
     * @param req
     * @return
     */
    DubboResult<Integer> selectAppFlowStrategyAmount(ReqPageQueryAppFlowStrategyData req);
    
    /**
     * 分页查询数据
     *
     * @author chencheng
     * @param req
     * @return
     */
    DubboResult<List<RspAppFlowStrategyPage>> selectAppFlowStrategyListByPage(ReqPageQueryAppFlowStrategyData req);
}
