package cn.com.duiba.tuia.core.api.remoteservice.permisson;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.permisson.RoleDto;
import cn.com.duiba.tuia.core.api.dto.req.permission.ReqPageQueryRoleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-08-24 16:53.
 */
public interface RemoteRoleService {

    /**
     * 查询角色列表(未删除)
     *
     * @param type 1-manager端的角色 0-web端的角色
     * @return 角色列表
     */
    DubboResult<List<RoleDto>> listByType(Integer type);

    DubboResult<Boolean> updateStatusToDelete(Long id);

    DubboResult<PageDto<RoleDto>> pageQuery(ReqPageQueryRoleDto queryRoleDto);

    DubboResult<Boolean> doesExist(String roleName, Integer type);

    DubboResult<Long> insert(String roleName, Integer type);

    DubboResult<Boolean> updateRoleName(Long roleId, String roleName, Integer type);

    DubboResult<RoleDto> get(Long roleId);

}
