/**
 * Project Name:tuia-core-api<br/>
 * File Name:AccountStatisticsDto.java<br/>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br/>
 * Date:2016年9月9日下午2:46:16<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

/**
 * 账户首页统计信息 <br/>
 * Date: 2016年9月9日 下午2:46:16 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class AccountStatisticsDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 5051374358213269614L;

    /** 账户余额 */
    private Long              balance;

    /** 广告主数量 */
    private Integer           advertiserNum;

    /** 今日消耗 */
    private Long              consumeTotal;

    /** 账户预算 */
    private Long              budgetPerDay;

    /** 区分是否为代理商视角 */
    private Boolean           isAgent;

    /**
     * isAgent.
     *
     * @return the isAgent
     * @since JDK 1.6
     */
    public Boolean getIsAgent() {
        return isAgent;
    }

    /**
     * isAgent.
     *
     * @param isAgent the isAgent to set
     * @since JDK 1.6
     */
    public void setIsAgent(Boolean isAgent) {
        this.isAgent = isAgent;
    }

    /**
     * budgetPerDay.
     *
     * @return the budgetPerDay
     * @since JDK 1.6
     */
    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    /**
     * budgetPerDay.
     *
     * @param budgetPerDay the budgetPerDay to set
     * @since JDK 1.6
     */
    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    /**
     * balance.
     *
     * @return the balance
     * @since JDK 1.6
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * balance.
     *
     * @param balance the balance to set
     * @since JDK 1.6
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    /**
     * advertiserNum.
     *
     * @return the advertiserNum
     * @since JDK 1.6
     */
    public Integer getAdvertiserNum() {
        return advertiserNum;
    }

    /**
     * advertiserNum.
     *
     * @param advertiserNum the advertiserNum to set
     * @since JDK 1.6
     */
    public void setAdvertiserNum(Integer advertiserNum) {
        this.advertiserNum = advertiserNum;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccountStatisticsDto [balance=");
        builder.append(balance);
        builder.append(", advertiserNum=");
        builder.append(advertiserNum);
        builder.append(", consumeTotal=");
        builder.append(consumeTotal);
        builder.append(", budgetPerDay=");
        builder.append(budgetPerDay);
        builder.append(", isAgent=");
        builder.append(isAgent);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
