package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.AdvertLimitDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAvertLimitingDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author: panaihua
 * @date: 2017年02月27日 19:09
 * @descript:
 * @version: 1.0
 */
public interface RemoteAdvertLimitingService {

	/**
	 * 更新限流媒体日预算和生效日期
	 * @param LimitingDto
	 * @return
	 * @throws TuiaCoreException
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateAdvertLimitingById(AdvertLimitDto LimitingDto);
	
    /**
     * 添加限流媒体
     * @param list
     * @return
     */
    DubboResult<Boolean> addLimiting(List<AdvertLimitDto> list);

    /**
     * 根据主键删除限流媒体
     * @param advertId
     * @param appId
     * @return
     */
    DubboResult<Boolean> delLimiting(Long advertId, Long appId);

    /**
     * 根据限流媒体编号和应用编号获取限流媒体
     * @param advertId
     * @param appIds
     * @param orientPkgId
     * @return
     */
    DubboResult<List<RspAvertLimitingDto>> getLimitingByQuery(Long advertId,List<Long> appIds, Long orientPkgId);
    
    /**
     * 更新限流媒体
     * @param advertId
     * @param orientPkgId
     * @param list
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateAdvertLimit(Long advertId, Long orientPkgId, List<AdvertLimitDto> list);

}
