/**
 * 文件名： AccountFinanceService.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月14日 下午1:56:31
 */
package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.ThirdRechargeRecordDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryThirdRechargeRecord;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 第三方支付相关功能 <功能详细描述>.
 *
 * @author: 李志辉
 * @创建时间: 2017年5月12日 下午1:56:31
 */
public interface RemoteThirdPaymentService {


    /**
     * 生成第三方充值记录
     * @param accountId 帐号id
     * @param amount    金额 单位:元 保留小数点后俩位
     * @return 返回订单号
     */
    DubboResult<String> generateRechargeInfo(Long accountId, Double amount, Integer type);

    /**
     * 通过记录id获取订单信息
     * @param rechargeId 充值记录id
     * @return 返回订单号
     */
    DubboResult<ThirdRechargeRecordDto> getRechargeInfo(Long rechargeId);


    /**
     * 充值
     * @param orderNumber 订单编号
     * @param remark 备注
     * @return 充值结果
     */
    DubboResult<Boolean> recharge(String orderNumber,String remark);

    /**
     * 分页查询充值记录
     * @param query  查询条件
     * @return 记录列表
     */
    DubboResult<PageDto<ThirdRechargeRecordDto>> getRechargeRecordList(ReqPageQueryThirdRechargeRecord query);

    /**
     * 充值失败时更新充值备注
     *
     * @param orderNumber 订单编号
     * @param remark      备注
     * @return 更新结果
     */
    DubboResult<Boolean> updateFailRemark(String orderNumber,String remark);
}
