package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.tuia.core.api.dto.advertiser.AccountRoleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/22 10:02
 * description:
 *
 * @since JDK 1.6
 */
public interface RemoteAccountRoleBackendService {

    /**
     * 根据账号id查询对应的角色id列表
     *
     * @param accountId 管理平台账号id 必传
     * @return 角色id列表
     */
    DubboResult<List<Long>> selectRoleIdsByAccountId(Long accountId);

    /**
     * 根据账号id删除指定的角色
     *
     * @param accountId 管理后台账号id
     * @param roleIds   需要删除的角色id
     * @return 删除的记录数
     */
    DubboResult<Integer> batchDelete(Long accountId, List<Long> roleIds);

    /**
     * 批量添加账户角色
     *
     * @param accountRoleList 账户角色列表
     * @return 插入的条数
     */
    DubboResult<Integer> batchInsert(List<AccountRoleDto> accountRoleList);

    /**
     * 删除账户角色
     *
     * @param accountId 管理平台账户id
     * @return 删除的标志 1 or 0
     */
    DubboResult<Integer> delete(Long accountId);

    /**
     * 通过角色id查询账户角色信息
     *
     * @param roleId 角色id
     * @return 角色信息
     */
    DubboResult<List<AccountRoleDto>> selectAccountByRoleId(Long roleId);

    /**
     * 根据角色id列表批量查询账户角色信息
     *
     * @param roleIds 角色id列表
     * @return 账户角色信息列表
     */
    DubboResult<List<AccountRoleDto>> selectAccountByRoleIds(List<Long> roleIds);

    /**
     * 通过账户id列表批量查询角色信息
     *
     * @param accountIds 账户id列表
     * @return 账户角色信息列表
     */
    DubboResult<List<AccountRoleDto>> selectRolesByAccountIds(List<Long> accountIds);
}
