package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.tuia.core.api.dto.AppDto;
import cn.com.duiba.tuia.core.api.dto.app.AppIdDto;
import cn.com.duiba.tuia.core.api.dto.app.ReqPageQueryAppDataDto;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAppDataReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 应用数据查询. <br/>
 * date: 2017年4月17日 下午2:31:05 <br/>
 *
 * @author chencheng
 */
public interface RemoteAppService {

    /**
     * 更新app新媒体策略标签信息.
     *
     * @param appId
     * @param flowBannedTags       新媒体策略屏蔽标签
     * @param flowBannedAdvertTags 新媒体策略广告标签
     * @return
     * @author chencheng
     */
    DubboResult<Integer> updateFlowBannedTag(Long appId, String flowBannedTags, String flowBannedAdvertTags);

    /**
     * 更新应用禁用标签
     *
     * @param appId
     * @param bannedTags
     * @param bannedAdvertTags
     * @param switchLuckybag   可为Null
     * @return
     */
    DubboResult<Integer> updateBannedTag(Long appId, String bannedTags, String bannedAdvertTags, Integer switchLuckybag);

    /**
     * 根据媒体id查询数据
     *
     * @param appId
     * @return
     */
    DubboResult<AppDto> selectByAppId(Long appId);

    /**
     * 批量查询app信息
     *
     * @param appIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppDto>> selectListByAppIds(List<Long> appIds);

    /**
     * 通过媒体名称模糊查询appIds
     *
     * @param appName
     * @return
     */
    DubboResult<List<Long>> selectAppIdsByName(String appName);

    /**
     * 应用信息导入广告平台.
     *
     * @param list the list
     * @return the int
     * @ 失败抛出异常
     */
    DubboResult<Integer> insertData(List<AppDto> list);

    /**
     * 广告平台标签不为空的记录.
     *
     * @return the list< app v o>
     * @ 失败抛出异常
     */
    DubboResult<List<AppDto>> exportTagData();

    /**
     * 查询应用列表.
     *
     * @param req the req
     * @return 应用列表
     * @ 失败抛出异常
     */
    DubboResult<List<AppDto>> selectListByPage(ReqPageQueryAppDataDto req);

    /**
     * 查询应用列表总数.
     *
     * @param req the req
     * @return 应用列表的记录总数
     * @ 失败抛出异常
     */
    DubboResult<Integer> selectAmountByPage(ReqPageQueryAppDataDto req);

    /**
     * 线程分批次获取广告平台App数据.
     *
     * @return 应用列表的记录
     * @ 失败抛出异常
     */
    DubboResult<List<AppDto>> getAppData(Long minId, Long maxId, Integer pageSize);


    /**
     * 广告平台新增app记录.
     *
     * @param apps the apps
     * @return the int
     * @ 失败抛出异常
     */
    DubboResult<Integer> insertManagerData(AppDto apps);

    /**
     * 广告平台新增app记录.
     *
     * @param apps the apps
     * @return the int
     * @ 失败抛出异常
     */
    DubboResult<Integer> updateManagerData(AppDto apps);


    /**
     * 查询广告平台App表最大，最小ID.
     *
     * @return the ids by manager
     * @ 失败抛出异常
     */
    DubboResult<AppIdDto> getIdsByManager();

    /**
     * 查询广告平台App表总量.
     *
     * @return the int
     * @ 失败抛出异常
     */
    DubboResult<Integer> selectTuiaAppCount();

    /**
     * 查询所有AppID. <br/>
     *
     * @return the list< long>
     * @author ZFZ
     * @since JDK 1.6
     */
    DubboResult<List<Long>> selectAllAppIds();

    /**
     * 更新该媒体是否发放福袋.
     *
     * @param appId          the app id
     * @param isSendLuckybag the is send luckybag
     * @return the int
     */
    DubboResult<Integer> updateSendLuckybag(Long appId, Integer isSendLuckybag);

    /**
     * selectIdsByAppNameOrSource:根据应用数据请求筛选应用id集合. <br/>
     *
     * @param req
     * @return
     * @author chencheng
     * @since JDK 1.6
     */
    DubboResult<List<Long>> selectIdsByAppDataReq(GetAppDataReq req);

    /**
     * 查询所有的app信息
     *
     * @return
     * @
     * @since JDK 1.6
     */
    DubboResult<List<AppDto>> selectAllAppInfo();

}
