package cn.com.duiba.tuia.core.api.remoteservice.finance;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.core.api.dto.finance.RechargeApplicationDto;
import cn.com.duiba.tuia.core.api.dto.finance.RechargeApplicationQueryDto;
import cn.com.duiba.tuia.core.api.dto.finance.RechargeCheckRecordDto;

/**
 * Created by lizhihui on 2017-10-17 17:08.
 */
public interface RemoteRechargeService {


    Boolean commitApplication(RechargeApplicationDto applicationDto);

    /**
     * 申请的拒绝
     *
     * @param id 充值申请的id
     * @param operatorId 操作人的id
     * @param reason 拒绝的原因
     * @return 拒绝结果 true-成功 false -失败
     */
    Boolean refuse(Long id, Long operatorId, String reason);

    /**
     * 获取该充值申请的类型
     * 
     * @param id 充值申请的id
     * @return 该充值申请的类型
     */
    Integer getApplicationType(Long id);

    /**
     * 财务助理同意该次申请接口
     *
     * @param id 充值申请的id
     * @param operatorId 操作人的id
     * @param secondExtend 同意申请时财务助理附带的一些内容
     * @return 同意结果 true-同意成功 false-同意失败
     */
    Boolean assistantAgree(Long id, Long operatorId, Map<String, Object> secondExtend);

    /**
     * 财务主管同意该次申请接口
     *
     * @param id 充值申请的id
     * @param operatorId 操作人的id
     * @return 同意结果 true-同意成功 false-同意失败
     */
    Boolean managerAgree(Long id, Long operatorId);

    /**
     * 获取该次申请的状态
     * 
     * @param id 充值申请的id
     * @return 充值申请的状态
     */
    Integer getApplicationStatus(Long id);

    /**
     * 统计申请的个数
     * 
     * @param queryDto 统计条件
     * @return 统计结果
     */
    int countApplication(RechargeApplicationQueryDto queryDto);

    /**
     * 获取申请列表
     * 
     * @param queryDto 查询条件
     * @return 充值申请列表
     */
    List<RechargeApplicationDto> applicationList(RechargeApplicationQueryDto queryDto);

    /**
     * 获取充值申请的信息
     * 
     * @param id 充值申请的id
     * @return 充值申请的信息
     */
    RechargeApplicationDto getApplication(Long id);

    /**
     * 获取充值申请的审核记录
     * 
     * @param id 充值申请的id
     * @return 充值申请的审核记录
     */
    List<RechargeCheckRecordDto> getApplicationCheckRecordList(Long id);
}
