/**
 * 文件名： AdvertiserDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月1日 下午1:36:56
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author: leiliang
 * @version:
 */
public class AccountDto extends BaseDto {

    private static final long serialVersionUID        = 4476874317666316204L;

    /** 邮箱未验证. */
    public static final int   EMAIL_STATUS_UNCHECK    = 0;

    /** 邮箱已验证. */
    public static final int   EMAIL_STATUS_CHECKED    = 1;

    /** 未冻结. */
    public static final int   UNFREEZED_STATUS        = 0;

    /** 已冻结. */
    public static final int   FREEZED_STATUS          = 1;

    /** 审核中. */
    public static final int   CHECK_STATUS_ING        = 0;

    /** 审核通过. */
    public static final int   CHECK_STATUS_PASS       = 1;

    /** 审核拒绝. */
    public static final int   CHECK_STATUS_REFUSE     = 2;

    /** 用户类型：0：广告主. */
    public static final int   USER_TYPE_OF_ADVERTISER = 0;
    
    /** 用户类型：代理商. */
    public static final int   USER_TYPE_AGENT         = 2;

    /** 邮箱. */
    private String            email;

    /** 密码. */
    private String            password;

    /** 公司名称. */
    private String            companyName;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer           freezeStatus;

    /** 邮箱状态:0：未验证;1：已验证. */
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    private Integer           checkStatus;

    /** 营业执照号. */
    private String            businessLicenseId;

    /** 营业执照名称. */
    private String            businessLicenseName;

    /** 营业执照照片. */
    private String            businessLicenseUrl;

    /** 公司地址. */
    private String            companyAddress;

    /** 联系人姓名. */
    private String            linkman;

    /** 联系人手机号. */
    private String            linkmanPhone;

    /** 联系人QQ. */
    private String            linkmanQQ;

    /** 用户类型. */
    private Integer           userType;

    /** 代理商ID. */
    private Long              agentId;

    /** 代理商公司名. */
    private String            agentCompanyName;

    /** 角色id. */
    private Long              roleId;

    /** 谷歌验证器秘钥. */
    private String            googleAuthKey;

    /** 操作员名. */
    private String            operatorName;
    
    public String getGoogleAuthKey() {
        return googleAuthKey;
    }

    public void setGoogleAuthKey(String googleAuthKey) {
        this.googleAuthKey = googleAuthKey;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public Integer getEmailStatus() {
        return emailStatus;
    }

    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    public String getBusinessLicenseName() {
        return businessLicenseName;
    }

    public void setBusinessLicenseName(String businessLicenseName) {
        this.businessLicenseName = businessLicenseName;
    }

    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

    public String getCompanyAddress() {
        return companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public String getLinkmanQQ() {
        return linkmanQQ;
    }

    public void setLinkmanQQ(String linkmanQQ) {
        this.linkmanQQ = linkmanQQ;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }
    public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
