/**
 * Project Name:manager-domain File Name:AdvertGroupVO.java Package Name:cn.com.duiba.tuia.manager.model
 * Date:2016年6月22日下午5:44:32 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:AdvertGroupVO <br/>
 * Reason: 广告组. <br/>
 * Date: 2016年6月22日 下午5:44:32 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class AdvertGroupDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long   serialVersionUID = 1L;

    /** id. */
    private Long                key;

    /** 广告组名称. */
    private String              groupName;

    /** 公司名称. */
    private String              companyName;

    /** 广告主账号. */
    private String              account;

    /** 关联广告列表. */
    private List<BindAdvertDto> ads;

    /**
     * Creates a new instance of AdvertGroupVO.
     */

    public AdvertGroupDto() {
        super();
    }

    /**
     * Creates a new instance of AdvertGroupVO.
     *
     * @param key the key
     * @param groupName the group name
     * @param companyName the company name
     * @param account the account
     */

    public AdvertGroupDto(Long key, String groupName, String companyName, String account) {
        super();
        this.key = key;
        this.groupName = groupName;
        this.companyName = companyName;
        this.account = account;
    }

    /**
     * key.
     *
     * @return the key
     * @since JDK 1.6
     */
    public Long getKey() {
        return key;
    }

    /**
     * key.
     *
     * @param key the key to set
     * @since JDK 1.6
     */
    public void setKey(Long key) {
        this.key = key;
    }

    /**
     * groupName.
     *
     * @return the groupName
     * @since JDK 1.6
     */
    public String getGroupName() {
        return groupName;
    }

    /**
     * groupName.
     *
     * @param groupName the groupName to set
     * @since JDK 1.6
     */
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.6
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.6
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * account.
     *
     * @return the account
     * @since JDK 1.6
     */
    public String getAccount() {
        return account;
    }

    /**
     * account.
     *
     * @param account the account to set
     * @since JDK 1.6
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * ads.
     *
     * @return the ads
     * @since JDK 1.6
     */
    public List<BindAdvertDto> getAds() {
        return ads;
    }

    /**
     * ads.
     *
     * @param ads the ads to set
     * @since JDK 1.6
     */
    public void setAds(List<BindAdvertDto> ads) {
        this.ads = ads;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertGroupDto [key=");
        builder.append(key);
        builder.append(", groupName=");
        builder.append(groupName);
        builder.append(", companyName=");
        builder.append(companyName);
        builder.append(", account=");
        builder.append(account);
        builder.append(", ads=");
        builder.append(ads);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
