package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.tuia.core.api.dto.advertiser.ManagerAccountDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/30 09:59
 * description:
 *
 * @since JDK 1.6
 */
public interface RemoteManagerAccountService {

    /**
     * 通过账号ID查询账户信息.
     *
     * @param accountId 管理员账户id
     * @return 管理员账户信息
     */
    DubboResult<ManagerAccountDto> getAccountByAccountId(Long accountId);

    /**
     * 通过账号查询账户信息.
     *
     * @param account 管理员账户名称
     * @return 管理员账户信息
     * @ 失败抛出异常
     */
    DubboResult<ManagerAccountDto> selectByAccount(String account);

    /**
     * insertAccount:(创建用户). <br/>
     *
     * @param req
     * @author ZFZ
     * @
     * @since JDK 1.6
     */
    DubboResult<Integer> insertAccount(ManagerAccountDto req);

    /**
     * 通过邮箱查询账户信息.
     *
     * @param email 账户邮箱地址
     * @return 管理员账户信息
     * @ 失败抛出异常
     */
    DubboResult<ManagerAccountDto> selectByEmail(String email);

    /**
     * 查询管理用户列表.
     *
     * @return the list
     * @ the tuia manager exception
     */
    DubboResult<List<ManagerAccountDto>> selectPageList(String name, List<Long> ids, Integer rowStart, Integer pageSize);

    /**
     * 查询管理用户总数.
     *
     * @return the Integer
     * @ the tuia manager exception
     */
    DubboResult<Integer> selectPageAmount(String name, List<Long> ids);

    /**
     * 更新管理员账户启用状态.
     *
     * @param id           the id
     * @param enableStatus the enable status
     * @return the Integer
     */
    DubboResult<Integer> updateEnableStatus(Long id, Integer enableStatus);

    /**
     * 删除管理员账户.
     *
     * @param id the id
     * @return the Integer
     * @ the tuia manager exception
     */
    DubboResult<Integer> delete(Long id);
}
