package cn.com.duiba.tuia.core.api.remoteservice.group;

import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.GroupMemberDto;
import cn.com.duiba.tuia.core.api.dto.group.AdvertGroupQueryDto;
import cn.com.duiba.tuia.core.api.remoteservice.group.data.AdvertGroupDO;
import cn.com.duiba.tuia.core.api.remoteservice.group.data.GroupMemberDO;
import cn.com.duiba.tuia.core.api.remoteservice.group.dto.AdvertGroupDto;
import cn.com.duiba.tuia.core.api.remoteservice.group.dto.GroupDataReqDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年06月20日 21:45
 * @descript:
 * @version: 1.0
 */
public interface RemoteAdvertGroupService {

    /**
     * 添加广告组
     * @param groupName
     * @param accountEmail
     * @param cid 操作账户的id
     * @return
     */
    DubboResult<Boolean> addAdvertGroup(String groupName,String accountEmail,Long cid);

    /**
     * 绑定广告组和广告关系
     * @param groupId
     * @param advertId
     * @param cid
     */
    DubboResult<Boolean> bindAdvertToGroup(Long groupId, Long advertId, Long cid,Boolean hasAllPermission);

    /**
     * 删除广告组
     * @param groupId
     * @return
     */
    DubboResult<Boolean> delAdvertGroup(Long groupId,Long cid,Boolean hasAllPermission);

    /**
     * 多条件分页查询广告组
     * @param advertGroupQueryDto
     * @param cid
     * @return
     */
    DubboResult<PageDto<AdvertGroupDto>> getAdvertGroupListByPage(AdvertGroupQueryDto advertGroupQueryDto, Boolean hasAllPermission,Long cid);

    /**
     * 更新广告组名称
     * @param cid
     * @param groupId
     * @param groupName
     */
    DubboResult<Boolean> updateGroupName(Long cid,Long groupId,String groupName,Boolean hasAllPermission);

    /**
     * 解除绑定
     * @param cid
     * @param advertId
     * @return
     */
    DubboResult<Boolean> unBind(Long cid,Long advertId,Boolean hasAllPermission);

    /**
     * 根据广告组列表获取广告计划列表
     * @param groupIds
     * @param cid
     * @return
     */
    DubboResult<List<GroupMemberDO>> getMembersByGroupIds(List<Long> groupIds,Long cid,Boolean hasAllPermission);

    /**
     * 查询分组的总数
     * @param groupDataReqDto
     * @return
     */
    DubboResult<Integer> getGroupForDataCount(GroupDataReqDto groupDataReqDto);

    /**
     * 分页获取广告组数据
     * @param groupDataReqDto
     * @return
     */
    DubboResult<List<AdvertGroupDO>> getGroupForData(GroupDataReqDto groupDataReqDto);

    DubboResult<List<AdvertGroupDO>> getGroupByIds(List<Long> ids);

    /**
     * 获取广告主的ID
     * @param advertIds
     * @return
     */
    DubboResult<List<GroupMemberDO>> getGroupIdByAdvertIds(List<Long> advertIds);


    DubboResult<GroupMemberDO> getGroupIdByAdvertId(Long advertId);

    DubboResult<List<GroupMemberDO>> getMembersByGroupId(Long groupId);

    DubboResult<GroupMemberDto> getGroupMember(Long id);

    DubboResult<String> getGroupName(Long groupId);
}
