/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertStatisticsHourRealTimeService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.statistics
 * Date:2017年8月26日下午4:52:46
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.req.data.ReqAdvertStatisticsHourRealTimeDto;
import cn.com.duiba.tuia.core.api.statistics.domain.AdvertStatisticsHourRealTimeRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdvertStatisticsHourRealTimeService <br/>
 * Function: 广告每小时数据实时数据查询. <br/>
 * Date:     2017年8月26日 下午4:52:46 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface RemoteAdvertStatisticsHourRealTimeService {
    /**
     * 
     * listTotalByAdvertIdsAndDate:(广告每小时数据实时数据查询). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<Integer> selectHourRealTimeDataAmount(ReqAdvertStatisticsHourRealTimeDto dto);
    
    /**
     * 
     * listTotalByAdvertIdsAndDate:(广告每小时数据实时数据查询). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<List<AdvertStatisticsHourRealTimeRsp>> selectHourRealTimeData(ReqAdvertStatisticsHourRealTimeDto dto);
   
}

