/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteLoadPageAppEffectStatisticsService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.statistics
 * Date:2017年8月26日下午4:52:52
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.req.data.ReqLoadingPageAppEffectDto;
import cn.com.duiba.tuia.core.api.dto.rsp.landingPage.RspLoadingPageAppEffectDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteLoadPageAppEffectStatisticsService <br/>
 * Function: 落地页APP维度数据查询. <br/>
 * Date:     2017年8月26日 下午4:52:52 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface RemoteLoadPageAppEffectStatisticsService {
    /**
     * 
     * listTotalByAdvertIdsAndDate:(落地页APP维度数据查询). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<List<RspLoadingPageAppEffectDto>> selectAppDataByAdvertIdsAndDate(ReqLoadingPageAppEffectDto dto);
    /**
     * 
     * listTotalByAdvertIdsAndDate:(落地页APP维度汇总数据查询). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<RspLoadingPageAppEffectDto> selectAppDataCountAllDay(ReqLoadingPageAppEffectDto dto);
    
    /**
     * 
     * countLoadingPagePlatformData:(落地页平台纬度数据总计). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    DubboResult<Integer> countLoadingPageAppData(ReqLoadingPageAppEffectDto dto);
}

