/**
 * Project Name:tuia-core-api<br>
 * File Name:EmployeeDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月7日下午1:45:37<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: EmployeeDto <br/>
 * Function: 协作员. <br/>
 * date: 2016年9月7日 下午1:45:37 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class EmployeeDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** 邮箱. */
    private String            email;

    /** 密码. */
    private String            password;

    /** 公司名称. */
    private String            companyName;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer           status;

    /** 角色id. */
    private Long              roleId;

    /** 代理商ID. */
    private Long              agentId;

    /** 谷歌验证器秘钥. */
    private String            googleAuthKey;

    /** 代理商名称. */
    private String            agentCompanyName;

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    public String getGoogleAuthKey() {
        return googleAuthKey;
    }

    public void setGoogleAuthKey(String googleAuthKey) {
        this.googleAuthKey = googleAuthKey;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EmployeeDto [email=");
        builder.append(email);
        builder.append(", password=");
        builder.append(password);
        builder.append(", companyName=");
        builder.append(companyName);
        builder.append(", status=");
        builder.append(status);
        builder.append(", roleId=");
        builder.append(roleId);
        builder.append(", agentId=");
        builder.append(agentId);
        builder.append(", googleAuthKey=");
        builder.append(googleAuthKey);
        builder.append(", agentCompanyName=");
        builder.append(agentCompanyName);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return ToStringBuilder.reflectionToString(this);
    }

}
