package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 资金类型 1开头表示账户流入 2开头表示账户支出 date: 2017年7月26日 下午3:44:51 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AccountFinanceTypeEnum {

    /** 记录类型： 充值 */
    BALANCE_RECHARGE(10, "账号充值"),

    /** 记录类型：代理商充值给广告主 */
    BALANCE_RECHARGE_AD_IN(12, "代理商划账"),

    /** 记录类型： 赠送.*/
    BALANCE_PRESENT(13, "赠送金额"),

    /** 记录类型：线上充值 */
    BALANCE_THIRD_PARTY_RECHARGE(14, "在线充值"),

    /** 记录类型：消费修正充值 */
    BALANCE_CONSUMER_CORRECTION_IN(15, "消费修正"),

    /** 记录类型：代理商回拨，代理商入账 */
    BALANCE_CALL_BACK_AGENT_IN(16, "代理商回拨"),

    /** 记录类型：广告主充值 */
    ADVERTISER_THIRD_PARTY_RECHARGE(17, "广告主充值"),

    /** 记录类型： 广告扣费 */
    BALANCE_ADVERT_EXPEND(20, "广告扣费"),

    /** 记录类型： 扣除金额(现金) */
    BALANCE_DEDUCTED(21, "扣除金额"),

    /** 记录类型：代理商为广告主充值支出 */
    BALANCE_RECHARGE_AGENT_OUT(22, "代理商划账"),

    /** 记录类型：消费修正扣费 */
    BALANCE_CONSUMER_CORRECTION_OUT(24, "消费修正"),

    /** 记录类型：代理商回拨，广告主出账 */
    BALANCE_CALL_BACK_AD_OUT(25, "代理商回拨"),

    /** 记录类型： 扣除金额(现金) */
    BALANCE_DEDUCTED_CASH_BACK(26, "扣除返货");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String  desc;

    private AccountFinanceTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, AccountFinanceTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AccountFinanceTypeEnum typeEnum : AccountFinanceTypeEnum.values()) {
            enumMap.put(typeEnum.code, typeEnum);
        }
    }

    public static AccountFinanceTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
